#ifndef QSCROBBLERCONFIG_H_INCLUDED
#define QSCROBBLERCONFIG_H_INCLUDED

#include "configview.h"
#include "kmdcodec.h"

class QLineEdit;

class QScrobblerConfiguration
{
public:
	QScrobblerConfiguration();

	void write(Config &cf) const;
	void read(Config &cf);

public:
	const QString username() const { return username_; }
	const QString md5Password() const { return md5Password_; }
	int cacheSaveInterval() const { return cacheSaveInterval_; }
	bool submissionPaused() const { return submissionPaused_; }

	void setUsername(const QString &username) { username_ = username; }
	void setMD5Password(const QString &password) { md5Password_ = password; }
	void setPassword(const QString &password)
	{
	    KMD5 m(password.utf8());
	    md5Password_ = m.hexDigest();
	}

	void setCacheSaveInterval(int interval) { cacheSaveInterval_ = interval; }
	void setSubmissionPaused(bool paused) { submissionPaused_ = paused; }

private:
	QString username_;
	QString md5Password_;
	int cacheSaveInterval_;
	bool submissionPaused_;
};

class QScrobblerConfig: public ConfigView
{
	Q_OBJECT
public:
	QScrobblerConfig(Configuration& configuration, QWidget *parent = 0, const char *name = 0);

	virtual void setStatesByConfiguration(const Configuration& config);
	virtual void saveStatesToConfiguration();

protected:
	void createWidgets();

private:
	QLineEdit *leUsername;
	QLineEdit *lePassword;
};

#endif // QSCROBBLERCONFIG_H_INCLUDED
