#include <stdlib.h>

#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>

#ifdef QTOPIA
#include <qpe/config.h>
#include <qpe/qcopenvelope_qws.h>
#endif

#include "externalservices.h"
#include "configuration.h"
#include "media.h"
#include "mediadatabase.h"

ExternalServices & ExternalServices::singleton()
{
	static ExternalServices instance;
	return instance;
}

ExternalServices::ExternalServices()
	:	currentMedia_(NULL)
{

}

ExternalServices::~ExternalServices()
{

}

QString ExternalServices::getTemporaryPlaybackStatusFileName()
{
	QString tempDir(::getenv("TMP"));
	if (tempDir.isEmpty())
	{
		tempDir = QString(::getenv("TMP"));
		if (tempDir.isEmpty())
		{
			tempDir = "/tmp";
		}
	}
	
	QString username(::getenv("USER"));
	if (!username.isEmpty())
		username = "_" + username;
	
	return tempDir + "/media" + username + ".sh";
}

void ExternalServices::playbackStarted(Media* media)
{
	currentMedia_ = media;
	
#ifdef QTOPIA
	if (media->isVideo())
	{
		if (qConfig.qcopBroadcastingEnabled)
		{
			QCopEnvelope e("QPE/MediaPlayer", "playingVideo(QString, int)");
			e << media->location().toString() << media->length();
		}
	}
	else if (media->isAudio())
	{
		if (qConfig.qcopBroadcastingEnabled)
		{
			if (media->location().isLocalFile())
			{
				QCopEnvelope e("QPE/MediaPlayer", "playingAudio(QString, QString, QString, QString, int)");
				e << media->location().toString() << media->title() << media->artist() << media->album() << media->length();
			}
			else
			{
				QCopEnvelope e("QPE/MediaPlayer", "playingStream(QString)");
				e << media->location().toString();
			}
		}
	}
#endif
	
	writeCurrentMediaStatusToFile("playback_started");
}

void ExternalServices::playbackStopped()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "stopped()");
#endif
	
	if (qConfig.createTemporaryPlaybackStatusFile)
	{
		QFile file(getTemporaryPlaybackStatusFileName());
		file.open(IO_WriteOnly);

		QTextStream ts(&file);
		ts.setEncoding(QTextStream::UnicodeUTF8);
		
		ts << "#!/bin/sh\n";
		ts << "# Auto-generated Quasar playback status file\n";
		ts << "# DO NOT EDIT!\n\n";
		ts << "status=stopped\n";

		file.close();
	}			
}

void ExternalServices::playbackSeekedToAbsoluteSeconds(int secs)
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "seeked(int)") << secs;
#endif
}

void ExternalServices::playbackPaused()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "paused()");
#endif
	
	writeCurrentMediaStatusToFile("paused");
}

void ExternalServices::playbackUnpaused()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "unpaused()");
#endif
	
	writeCurrentMediaStatusToFile("playing");
}

void ExternalServices::writeCurrentMediaStatusToFile(const QString &statusString)
{
	if (qConfig.createTemporaryPlaybackStatusFile && currentMedia_)
	{
		QFile file(getTemporaryPlaybackStatusFileName());
		file.open(IO_WriteOnly);

		QTextStream ts(&file);
		ts.setEncoding(QTextStream::UnicodeUTF8);
		
		ts << "#!/bin/sh\n";
		ts << "# Auto-generated Quasar playback status file\n";
		ts << "# DO NOT EDIT!\n\n";
		ts << "status=" << statusString << "\n";
		ts << "mediatype=" << (currentMedia_->isVideo() ? "video" : currentMedia_->isAudio() ? "audio" : "stream") << "\n"; 
		ts << "artist=\"" << escapeString(currentMedia_->artist()) << "\"\n";
		ts << "album=\"" << escapeString(currentMedia_->album()) << "\"\n";
		ts << "title=\"" << escapeString(currentMedia_->title()) << "\"\n";
		//ts << "genre=" << escapeString(currentMedia_->genre()) << "\n";
		ts << "trackno=" << currentMedia_->trackNo() << "\n";
		ts << "length=" << currentMedia_->length() << "\n";
		ts << "location=\"" << currentMedia_->location().toString() << "\"\n";
								
		file.close();
	}				
}

QString ExternalServices::escapeString(const QString &in)
{
	QString retval = in;
	retval.replace(QRegExp("\""), "\\\"");
	retval.replace(QRegExp("\\"), "\\\\");
	//retval.replace(QRegExp("$"), "\\$");
	return retval;
}