#!/bin/bash

TARGET="Sharp Qtopia"
BINARY_NAME="quasar"

SCRIPT_FILENAME="`cd \`dirname \"$0\"\`; pwd`/`basename \"$0\"`"
DISTRO_ROOT=$(dirname "$SCRIPT_FILENAME")

source "$DISTRO_ROOT/makedistro-common.sh.in"

function prepareMakefile()
{
	tmake quasar-common.pro.in quasar-sharp-qtopia.pro addons/quasar-addons.pro.in > Makefile
}

buildBinary "$TOOLS_ROOT/devenv-arm-sharp-qtopia.sh"
copySkeletonBinaryAndSkins "$DISTRO_ROOT/skeletons/sharp-qtopia" "$INPUT_ROOT/opt/QtPalmtop/bin/quasar" "$INPUT_ROOT/opt/QtPalmtop/share/quasar/skins"

# copy images
IMAGE_ROOT="$INPUT_ROOT/opt/QtPalmtop/pics/quasar"
rm -f "$IMAGE_ROOT/"* > /dev/null 2>&1
cp "$DISTRO_ROOT/images/"* "$IMAGE_ROOT/"

removeObsoleteFiles

# create package
PACKAGE_FILENAME="$INPUT_ROOT/quasar.ipk"
insertVersionIntoFile "$INPUT_ROOT/CONTROL/control"
"$TOOLS_ROOT/ipkg-build" "$INPUT_ROOT" "$PACKAGE_FILENAME" || onError "Building IPKG failed."
movePackageToDestination "$PACKAGE_FILENAME" "$OUTPUT_ROOT/quasar_${APPVERSION_FILENAME_SUFFIX}_arm.ipk" "$1"

cleanUp
