/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef QUASAR_H_INCLUDED
#define QUASAR_H_INCLUDED

#include <qmainwindow.h>
#include <qstring.h>
#include <qaction.h>
#ifdef QTOPIA
#include <qpe/qpestyle.h>
#endif
#ifdef WINDOWS
#include <qwindowsstyle.h>
#endif

#include "playlistmanager.h"
#include "skinmanager.h"

class MPlayer;
class QWidgetStack;
class Configuration;
class MediaDatabase;
class PlayList;
class PlayListOverview;
class CoverArtImageProvider;
class LayeredPaintBox;
class CoverArtFlow;
class SkinFlowScrollBar;
class OperationPanel;
class ToolPanel;
class PlayListToolPanel;
class PlayInfo;
class VideoPlaybackWindow;
class SkinManager;
class QVBoxLayout;
class QVBox;
class QMenuBar;
class QToolBar;
class QCloseEvent;
class QResizeEvent;
class QKeyEvent;
class QLineEdit;
class QSplitter;

class Quasar: public QMainWindow
{
	Q_OBJECT

signals:
	void mplayerQuit();

	void playbackStarted(Media* media);
	void playbackStopped();

	void playbackSeekedToAbsoluteSeconds(int);

	void playbackPaused();
	void playbackUnpaused();

public:
	Quasar();
	~Quasar();

	enum View {
		ViewDynPlaylistEditor = 0,
		ViewOpenedPlaylist = 1,
		ViewOnTheGoPlaylist = 2,
		ViewLastActivePlaylist = 3,
		ViewPlayInfo = 4,
		ViewMax = 5
	};

	View activeView();
	bool setActiveView(View view);

public slots:
	// playback control
	void play_pause();
	void stop_play();
	void stop();
	void next();
	void previous();
	void setPlayOrder(int);
	void setOverviewVisibility(bool visible);
	void setCoverArtFlowVisibility(bool visible);
	void setInputMode(PlayList::InputMode inputMode);
	void setFullScreen(int);

public slots:
	void init();

	void coverArtFlowAreaRearrangeLayers();

	void play_pause(bool forcePlayNewFile);

	// Configuration dialog
	void configuration();

	void toggleFullScreen();
	void toggleInfoWidget();
	void togglePlayOrder();
	void toggleRandomPlayOrder();
	void toggleOverviewVisibility();
	void toggleCoverArtFlowVisibility();
	void toggleSelectMode() { setInputMode(PlayList::Select); }
	void toggleMultiSelectMode() { setInputMode(PlayList::MultiSelect); }
	void toggleMoveItemMode() { setInputMode(PlayList::Move); }
	void about();
	void rescanForCoverArt();
	void showMediaInfo();

	void setAbsoluteSeconds(int);
	void setRelativeSeconds(int);
	void osdTimerTimedUpdate();

	void setDocument(const QString&);

	void handleExternalDocuments(const QStringList &filenames);

	void mplayerCurrentPlayTime(int seconds);
	void mplayerErrorMessage(QString);

	void resetFilterAndSorting();

	void filterEditBoxReturnPressed();
	void filterEditBoxTextChanged(const QString&);
	void filterEditBoxTimedUpdate();

	void setFilter(const QString&);
	void resetFilter();
	void resetFilterAndFocusFilterEditBox();

	void updateButtonAndMenuState();
	void scheduleUpdateButtonAndMenuState();

	void fileMenuAboutToShow();
	void editMenuAboutToShow();
	void viewMenuAboutToShow();
	void toolsMenuAboutToShow();

	void switchPlaylistEditorView();
	void switchToLastActivePlayList();
	void switchToCurrentPlayList();
	void switchToOnTheGoPlayList();
	void switchToInfoWidget();

	void playlistViewUpdated();
	void playlistViewSorted();
	void playlistManagerSwitchingModeTo(PlayListManager::Mode mode);
	void playlistManagerSwitchedModeTo(PlayListManager::Mode mode);
	void playlistToolPanelModeChanged(PlayListManager::Mode mode);
	void playlistManagerPlayListFileNameChanged();
	void playlistManagerPlayListCleared();
	void playlistManagerPlayListFilterChanged(const QString &filter);

	void playlistOverviewFocusOutLeft();
	void playlistOverviewFocusOutRight();
	void setFocusPlayListOverview();

	void incDisplaySize();
	void decDisplaySize();

	void loadPrimarySkin();
	void loadSecondarySkin();

protected:
	void closeEvent(QCloseEvent*);
	void resizeEvent(QResizeEvent *);

#ifndef QTOPIA
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);
#endif

	bool eventFilter(QObject *, QEvent *);

private:
	int fullScreenMenuItemID_;
	enum WIDGETID {
		InfoWidget, PlayListWidget
	};

	bool filterActive();

	// メニューバーのセット
	void setupMenu();

	QAction *createAction(const QCString& actionName, const QObject *receiver, const char *member);
	int createMenuItem(QPopupMenu *menu, const QCString &menuText, QAction *action);
	void setupActions();

	void setPlayListFont(SkinManager::InfoMode mode);
	void changeOrientation(bool landscape, bool setSkinStyle = true, bool saveCurrentColumnWidths = true);
	void checkOrientation();

	void configuration(bool showMPlayerConfig);
	void readFromConfig();

	void startPlaying();
	void stopPlaying(bool temporarily = false, bool stopBackend = true);

	void updateSplitterSectionHeights();

	void loadSkin(const QString &name, bool force = false);

	int keyEventCount_;

	MPlayer *mplayer_;

	bool receivedExternalDocuments_;
	bool isFullScreen_;
	bool wasMaximized_;

	QString prevFilterString_;

	QString newFilterText_;
	QTimer *filterEditTimer_;
	QTimer *osdTimer_;
	VideoPlaybackWindow *videoPlaybackWindow_;
	QTimer *updateButtonAndMenuTimer_;

	bool nextMediaPrefetched_;
	int currentMediaLength_;

public:
	SkinManager *skinManager_;

	// Widgets
	QWidget *centralWidget_;

	PlayListManager *playListManager_;
	PlayList *playList_;
	PlayListOverview *playListOverview_;
	CoverArtImageProvider *coverArtProviderCoverArtFlow_;
	CoverArtImageProvider *coverArtProviderPlayInfo_;

	LayeredPaintBox *coverArtFlowArea_;
	CoverArtFlow *coverArtFlow_;
	SkinFlowScrollBar *flowScrollBar_;

	PlayInfo *playInfo_;
	OperationPanel *operationPanel_;
	ToolPanel *toolPanel_;
	PlayListToolPanel *playListToolPanel_;
	QLineEdit *filterEditBox_;

	// Layout
	int currentWidth_;
	QVBoxLayout *screen_;	// Screen layout
	QWidgetStack *widgetStack_, *playlistStack_;
	QVBox *playListContainer_;
	QSplitter *horizontalSplitterContainer_;
	QSplitter *verticalSplitterContainer_;

	// Menu
	QMenuBar *menuBar_;
	QPopupMenu *fileMenu_, *playbackOrderMenu_, *controlsMenu_, *sortByMenu_, *editMenu_, *viewMenu_, *toolsMenu_;

	QToolBar *toolBar_;
	QToolBar *subBar_;

	int idFileMenuNewPlaylist_;
	int idFileMenuNewDynPlaylist_;
	int idFileMenuOpenPlaylist_;
	int idFileMenuSavePlaylist_;
	int idFileMenuSaveAsPlaylist_;

	int idEditMenuCutItem_;
	int idEditMenuCopyItem_;
	int idEditMenuPasteItem_;
	int idEditMenuDeleteItem_;
	int idEditMenuSelectModeItem_;
	int idEditMenuMultiSelectModeItem_;
	int idEditMenuMoveItemModeItem_;
	int idEditMenuCopyToOTGItem_;
	int idEditMenuShowMediaInfoItem_;

	int idViewMenuFullscreenItem_;
	int idViewMenuShowOverviewItem_;
	int idViewMenuShowCoverArtFlowItem_;
	int idViewMenuCurrentPlayListItem_;
	int idViewMenuOnTheGoPlayListItem_;
	int idViewMenuDynamicPlayListEditorItem_;
	int idViewMenuPlayInfoItem_;
	int idViewMenuIncDisplaySize_;
	int idViewMenuDecDisplaySize_;
	int idViewMenuQuickswitchSkin1_;
	int idViewMenuQuickswitchSkin2_;

	int idToolsMenuRescanDynamicPlaylist_;
	int idToolsMenuRescanForCoverArt_;
	int idToolsMenuConfiguration_;
	int idToolsMenuAbout_;

	QAction *acPlayInfoToggle;
	QAction *acMoveBack;
	QAction *acMoveForward;
	QAction *acDelete;
};

#endif // QUASAR_H_INCLUDED
