/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GENERALCONFIG_H_INCLUDED
#define GENERALCONFIG_H_INCLUDED

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include "configuration.h"
#include "configview.h"

class GeneralConfig : public ConfigView
{
	Q_OBJECT
public:
	GeneralConfig(Configuration& configuration, QWidget *parent = 0, const char *name = 0) : ConfigView(configuration, parent, name) {}
	virtual void setStatesByConfiguration(const Configuration& config);

protected:
	virtual void createWidgets();

signals:
	void nukeMediaCacheButtonClicked();
	void defaultButtonClicked();

private slots:
	void setBatteryPlusEnabled(bool b) {
#ifdef QTOPIA
		config().isBatteryPlusEnabled = b;
		batteryPlusMode4Video_->setEnabled(b);
		batteryPlusMode4Audio_->setEnabled(b);
#endif
	}
	void setBatteryPlusMode4Video(int i) {
#ifdef QTOPIA
		config().batteryPlusMode4Video = ((i == 0) ? QString() : batteryPlusMode4Video_->text(i));
#endif
	}
	void setBatteryPlusMode4Audio(int i) {
#ifdef QTOPIA
		config().batteryPlusMode4Audio = ((i == 0) ? QString() : batteryPlusMode4Audio_->text(i));
#endif
	}

	void setBackendLoggingEnabled(bool b) {
		config().isBackendLoggingEnabled = b;
		backendLogFileName_->setEnabled(b);
	}
	void setBackendLogFileName(const QString& text) { config().backendLogFileName = text; }
	void confirmCompactMediaDatabase();
	void confirmRevertDefaultSettings();

	void setAutomaticallySwitchToPlayInfoEnabled(bool b) { config().automaticallySwitchToPlayInfoEnabled = b; }
	void setAskQuitingEnabled(bool b) { config().isAskQuitingEnabled = b; }
	void setRegisterAsRemoteConMaster(bool b) { config().registerAsRemoteConMaster = b; }
	void setQCopBroadcastingEnabled(bool b) { 	config().qcopBroadcastingEnabled = b; }
	void setCreateTemporaryPlaybackStatusFile(bool b) { config().createTemporaryPlaybackStatusFile = b; }

private:
// MOC_SKIP_BEGIN
#ifdef QTOPIA
	void insertBatteryPlusModes(QComboBox *combo);
	bool setBatteryPlusCurrentMode(QComboBox *combo, const QString& mode);

	QCheckBox *isBatteryPlusEnabled_;
	QComboBox *batteryPlusMode4Video_;
	QComboBox *batteryPlusMode4Audio_;

	QCheckBox *registerAsRemoteConMaster_;
	QCheckBox *broadcastingEnabled_;
#endif
// MOC_SKIP_END

	QCheckBox *createTemporaryPlaybackStatusFile_;

	QCheckBox *isBackendLoggingEnabled_;
	QLineEdit *backendLogFileName_;

	QCheckBox *automaticallySwitchToPlayInfoEnabled_;
	QCheckBox *isAskQuitingEnabled_;
};

#endif // GENERALCONFIG_H_INCLUDED
