/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPLAYERCONFIG_H_INCLUDED
#define MPLAYERCONFIG_H_INCLUDED

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlineedit.h>

#include "configuration.h"
#include "configview.h"

class QHButtonGroup;

class MPlayerConfig : public ConfigView
{
	Q_OBJECT
public:
	MPlayerConfig(Configuration& configuration, QWidget *parent = 0, const char *name = 0);

	virtual void setStatesByConfiguration(const Configuration& config);

	void focusMPlayerPathWidget() { mplayerPath_->setFocus(); }

protected:
	virtual void createWidgets();

private slots:
	void setOverlayEnabled(bool b) { config().isOverlayEnabled = b; }
	void setDoubleBufferingEnabled(bool b) { config().isDoubleBufferingEnabled = b; }
	void setFramedropMethod(int index) {
		config().framedropMethod = static_cast<Configuration::FramedropMethod>(index);
	}

	void setCacheEnabled(bool b) { config().isCacheEnabled = b; cacheSize_->setEnabled(b); }
	void setCacheSize(int value) { config().cacheSize = value; }
	void setPrefetchFileEnabled(bool b) { config().isPrefetchFileEnabled = b; }

	void setAdditionalOptionsEnabled(bool b) {
		config().isAdditionalOptionsEnabled = b;
		additionalOptions_->setEnabled(b);
	}
	void setAdditionalOptions(const QString& value) { config().additionalOptions = value; }

	void setMPlayerPath(const QString& path) { config().mplayerPath = path; }
	void execMPlayerPathDialog();

private:
	// Widgets
	QCheckBox *isOverlayEnabled_;
	QCheckBox *isDoubleBufferingEnabled_;
	QHButtonGroup *framedropMethod_;
	QCheckBox *isAdditionalOptionsEnabled_;
	QLineEdit *additionalOptions_;
	QLineEdit *mplayerPath_;
	QCheckBox *isCacheEnabled_;
	QSpinBox *cacheSize_;
	QCheckBox *isPrefetchFileEnabled_;
};

#endif // MPLAYERCONFIG_H_INCLUDED
