/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SKINNEDTIMELABEL_H_INCLUDED
#define SKINNEDTIMELABEL_H_INCLUDED

#include <qframe.h>
#include <qstring.h>
#include "skin.h"
#include "skinmanager.h"

// Forward declarations
class QPainter;

class SkinnedTimeLabel : public QFrame
{
	Q_OBJECT

public:
	SkinnedTimeLabel(Skin::PartsType type, const SkinManager *skinmgr, QWidget *parent = 0, const char *name = 0);

	QSize sizeHint() const;
	QSize minimumSizeHint() const { return sizeHint(); }
	QSizePolicy sizePolicy() const;

public slots:
	void setSecond(int);
	void setSkin(const Skin *);

protected:
	void drawContents(QPainter *p);

private slots:
	void skinPanelResized();
	
private:
	Skin::PartsType type_;
	const SkinParts *parts_;
	int fontWidth_;
	int second_;
	QString format_;
};



#endif // SKINNEDTIMELABEL_H_INCLUDED
