/*
 * debugaddon.h
 *
 *  Created on: 10.03.2009
 *      Author: darkstar
 */

#ifndef DEBUGADDON_H_
#define DEBUGADDON_H_

#include <qmenubar.h>
#include <qmessagebox.h>
#include <qimage.h>

#include "quasar.h"
#include "addonmanager.h"
#include "imagefx.h"
#include "coverartflow.h"
#include "helpers.h"

class DebugAddOn : public AddOn
{
	Q_OBJECT
public:
	DebugAddOn()
		:	AddOn()
	{
		qDebug("Registering DebugAddOn");
	}

	virtual ~DebugAddOn()
	{
	}

	virtual void init();
	virtual void deinit();

	virtual void hookMainWindow(Quasar *mainWindow)
	{
		mainWindow_ = mainWindow;
		QPopupMenu *debugMenu = new QPopupMenu(mainWindow->menuBar_);
		debugMenu->insertItem(tr("Benchmark projective transformation..."), this, SLOT(benchmarkProjectiveTransformation()));
		debugMenu->insertItem(tr("Get proxy settings..."), this, SLOT(getProxySettings()));
#ifdef OSX
		debugMenu->insertItem(tr("Show debug console..."), this, SLOT(showDebugConsole()));
#endif
		mainWindow->menuBar_->insertItem(tr("Debug"), debugMenu);
	}

private slots:
	void benchmarkProjectiveTransformation()
	{
		QImage image;
		image.load(mainWindow_->coverArtProviderCoverArtFlow_->preloadImageFilename());

		QImage buffer(640, 480, 32);

		QTime time;
		time.start();

		int loops = 1000;
		FloatPoint p1, p2, p3, p4;
		QRect dstClip = buffer.rect();

		for (int i = 0; i < loops; ++i)
		{
			buffer.fill(0xffffff);

			ImageFX::calculatePerspectivePoints(
				320, 50, 440, 380,
				(float)1/(i+1), 0.2, 0.5, false,
				p1, p2, p3, p4
			);



			ImageFX::projectiveTransformation(
				image, buffer, dstClip,
				p1, p2, p3, p4,
				true
			);
		}

		int elapsed = time.elapsed();

		QMessageBox::information(mainWindow_, "Benchmark", QString().sprintf("Elapsed: %d ms, Avg: %f ms", elapsed, (float)elapsed / loops));

		buffer.save("/Users/darkstar/Desktop/quasar.jpg", "JPEG");
	}

	void getProxySettings()
	{
		QString host;
		int port;

		if (getHTTPProxySettings(host, port))
			qDebug("HTTP proxy is enabled: %s:%d", (const char *)host.latin1(), port);
		else
			qDebug("No http proxy configured.");
	}

	void showDebugConsole();

private:
	Quasar *mainWindow_;
};

#endif /* DEBUGADDON_H_ */
