/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2006 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef DEBUG_H_INCLUDED
#define DEBUG_H_INCLUDED

#include <time.h>

#include <qobject.h>
#include <qstring.h>

#ifdef DEBUG
void kaDebugEnterMethod(const QString &name);
void kaDebugExitMethod(const QString &name);
void kaDebug(const QString &msg);
void kaPrintMemStat();
  #define DENTERMETHOD(x...) kaDebugEnterMethod(QString().sprintf(x))
  #define DEXITMETHOD(x...) kaDebugExitMethod(QString().sprintf(x))
  #define DHENTERMETHOD(x...)
  #define DHEXITMETHOD(x...)
  #define DPRINTF(x...) kaDebug(QString().sprintf(x))
  #define DHPRINTF(x...)
  #define DOP(x...) x
  #define DHOP(x...) x

///*
  #define DTIMERINIT(timername) QTime timername; timername.start()
  #define DTIMERSTART(timername) timername.start()
  #define DTIMERPRINT(timername, description) kaDebug(QString().sprintf("[Timing] %-30s: %5d ms", description, timername.elapsed()))
//*/
  #define DMEMSTAT() //kaPrintMemStat()

/*
# define DTIMERINIT(timername) clock_t timername = clock();
# define DTIMERSTART(timername) timername = clock();
# define DTIMERPRINT(timername, description) DPRINTF("[Timing] %-30s: %5d ms", description, (int)(((1.0 * clock() - timername) / CLOCKS_PER_SEC) * 1000));
//*/

#else
  #define DENTERMETHOD(x...)
  #define DEXITMETHOD(x...)
  #define DHENTERMETHOD(x...)
  #define DHEXITMETHOD(x...)
  #define DPRINTF(x...)
  #define DHPRINTF(x...)
  #define DOP(x...)
  #define DHOP(x...)

  #define DTIMERINIT(timername)
  #define DTIMERSTART(timername)
  #define DTIMERPRINT(timername, description)

  #define DMEMSTAT()
#endif

#endif /* DEBUG_H_INCLUDED */
