/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * This file based on eMotion by Michael Swieton <mike@swieton.net>
 *
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SIGNALHANDLER_H
#define SIGNALHANDLER_H

/** Allow a class to receive a signal */
class SignalHandler
{
public:
	SignalHandler () {};
	inline virtual ~SignalHandler () {};
	virtual void handleSignal (int) = 0;
};

/** attempt to register an object as a signal handler for the specified
 * signal, if there is not any current handler for that signal. An
 * exception is reported to the ErrorMediator if this is not possible */
void register_handler (int sig, SignalHandler *h);
/** unregister the specified handler object */
void unregister_handler (SignalHandler *h);

#endif
