/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qtextcodec.h>
#include <qfileinfo.h>
#include "simplefiledialog.h"
#include "mplayerconfig.h"

/*! configの値を初期値にして構築
*/
MPlayerConfig::MPlayerConfig(Configuration& configuration, QWidget *parent, const char *name)
	: ConfigView(configuration, parent, name)
{
}

/*! \a config を元にして各Widgetの状態を設定します。
 */
void MPlayerConfig::setStatesByConfiguration(const Configuration& config)
{
	ConfigView::setStatesByConfiguration(config);

	if (config.machineCategory() == Configuration::MACHINE_GENERIC) {
		isOverlayEnabled_->setChecked(false);
		isOverlayEnabled_->hide();
	} else {
		isOverlayEnabled_->setChecked(config.isOverlayEnabled);
		isOverlayEnabled_->show();
	}
	isDoubleBufferingEnabled_->setChecked(config.isDoubleBufferingEnabled);
	reinterpret_cast<QRadioButton *>(framedropMethod_->find(config.framedropMethod))->setChecked(true);
	isAdditionalOptionsEnabled_->setChecked(config.isAdditionalOptionsEnabled);

	isCacheEnabled_->setChecked(config.isCacheEnabled);
	cacheSize_->setValue(config.cacheSize);
	isPrefetchFileEnabled_->setChecked(config.isPrefetchFileEnabled);

	additionalOptions_->setText(config.additionalOptions);
	additionalOptions_->setEnabled(config.isAdditionalOptionsEnabled);
	mplayerPath_->setText(config.mplayerPath);
}

/*! 使用するWidgetを確保する
*/
void MPlayerConfig::createWidgets()
{
	ConfigView::createWidgets();

	setFrameStyle(NoFrame);
	setMargin(4);
	setResizePolicy(AutoOneFit);

	QVBox *bigbox = new QVBox(viewport());
	bigbox->setSpacing(4);
	addChild(bigbox);

	// ----------------
	QVGroupBox *group = new QVGroupBox(tr("MPlayer settings"), bigbox);

	isOverlayEnabled_ = new QCheckBox(tr("Enable video overlay (BVDD / ATI W100)"), group);
	connect(isOverlayEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setOverlayEnabled(bool)));

	isDoubleBufferingEnabled_ = new QCheckBox(tr("Enable double buffering (for OSD and smoother playback)"), group);
	connect(isDoubleBufferingEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setDoubleBufferingEnabled(bool)));

	QHBox *hbox = new QHBox(group);
	hbox->setSpacing(4);

	isCacheEnabled_ = new QCheckBox(tr("Enable file cache:"), hbox);
	connect(isCacheEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setCacheEnabled(bool)));

	cacheSize_ = new QSpinBox(128, 16384, 128, hbox);
	cacheSize_->setSuffix(" KiB");
	connect(cacheSize_, SIGNAL(valueChanged(int)), this, SLOT(setCacheSize(int)));

	isPrefetchFileEnabled_ = new QCheckBox(tr("Enable file prefetching"), group);
	connect(isPrefetchFileEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setPrefetchFileEnabled(bool)));

	framedropMethod_ = new QHButtonGroup(tr("Framedrop method"), group);
	framedropMethod_->setExclusive(true);
	new QRadioButton(tr("None"), framedropMethod_);
	new QRadioButton(tr("Normal"), framedropMethod_);
	new QRadioButton(tr("Hard (may crash MPlayer)"), framedropMethod_);
	connect(framedropMethod_, SIGNAL(clicked(int)), this, SLOT(setFramedropMethod(int)));

	isAdditionalOptionsEnabled_ = new QCheckBox(tr("Use addtional options:"), group);
	connect(isAdditionalOptionsEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setAdditionalOptionsEnabled(bool)));
	additionalOptions_ = new QLineEdit(group);
	connect(additionalOptions_, SIGNAL(textChanged(const QString&)),
			this, SLOT(setAdditionalOptions(const QString&)));

	// ----------------
	QHGroupBox *pathGroup = new QHGroupBox(tr("MPlayer location"), bigbox);
	mplayerPath_ = new QLineEdit(pathGroup);
	connect(mplayerPath_, SIGNAL(textChanged(const QString&)),
			this, SLOT(setMPlayerPath(const QString&)));
	QPushButton *openButton = new QPushButton(tr("..."), pathGroup);
	connect(openButton, SIGNAL(clicked()), this, SLOT(execMPlayerPathDialog()));
}

void MPlayerConfig::execMPlayerPathDialog()
{
	QString selectedFilename = SimpleFileDialog::getOpenFileName(
		QFileInfo(mplayerPath_->text()).filePath(),
		"All Files (*.*)",
		this,
		"locate mplayer dialog",
		tr("Locate MPlayer binary")
	);

	if (!selectedFilename.isNull())
		mplayerPath_->setText(selectedFilename);
}
