/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef OPERATIONPANEL_H_INCLUDED
#define OPERATIONPANEL_H_INCLUDED

#include <qwidget.h>
#include <qbutton.h>
#include <qframe.h>
#ifdef QTOPIA
#include <qpe/qcopenvelope_qws.h>
#endif

#include "skinpanel.h"

// Forward declarations
class Skin;
class SkinParts;
class SkinnedButton;
class SkinnedTimeLabel;
class SkinManager;
class SeekBar;
class QImage;

class OperationPanel : public SkinPanel
{
	Q_OBJECT

public:
	OperationPanel(const SkinManager *, QWidget *parent = 0, const char *name = 0);
	virtual ~OperationPanel();

	void setPlayPause(bool isPlay);

public slots:
	void setCurrentPlayTime(int secs = 0);
	void setTotalPlayTime(int secs = 0);
	void showPlaybackWidgets();
	void hidePlaybackWidgets();

private slots:
	void seekBarSliderMoved(int);
	void seekBarSliderReleased();
	void seekBarSliderStepped(int);
	
	void volBarSliderMoved(int);
	void volBarSliderReleased();
	void volBarSliderStepped(int);
	
	void sysMessage(const QCString &msg, const QByteArray &data);
	
signals:
	void playClicked();
	void stopClicked();
	void nextClicked();
	void previousClicked();
	void seek(int);
	void volume(int);

private:
	SkinnedButton *playButton_;
	SkinnedButton *pauseButton_;
	SkinnedTimeLabel *currentPlayTime_;
	SkinnedTimeLabel *totalPlayTime_;

	SeekBar *seekBar_;
	int seekPosition_;
	int prevSecsValue_;

// MOC_SKIP_BEGIN
#ifdef QTOPIA	
	QCopChannel *sysChannel_;
#endif
// MOC_SKIP_END
	
	SeekBar *volBar_;
	int volPosition_;
};

#endif // OPERATIONPANEL_H_INCLUDED
