/*
 * Copyright (C) 2007 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef QSCROBBLER_H_INCLUDED
#define QSCROBBLER_H_INCLUDED

#include <qdialog.h>
#include <qwidget.h>
#include <qstring.h>
#include <qdatetime.h>

class Configuration;
class AudioScrobbler;
class QLabel;
class QProgressBar;
class QTimer;
class QListView;
class QVGroupBox;
class QWidgetStack;

class QScrobbler: public QDialog
{
	Q_OBJECT

public:
	QScrobbler(AudioScrobbler *asc, QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	virtual ~QScrobbler();

protected:
	void closeEvent(QCloseEvent *);
	void done(int r);
	void showEvent(QShowEvent *);

private:
	AudioScrobbler *scrobbler;
    QLabel *currentlyPlayingLabel;
    QLabel *statusLabel;
    QProgressBar *progressBar;
    QTimer *updateTimer;
    QVGroupBox *gbox0;
    QListView *scrobbledTracksListView;
    QVGroupBox *gbox1;
    QWidgetStack *progressStack;
    QLabel *progressStatus;

#ifndef QTOPIA
    QDateTime lastDateTimeOfPolledFile;
    QString getTemporaryPlaybackStatusFileName();
#endif

signals:
	void closing();

private slots:
	void about();
	void updateTimerTriggered();
	void clearScrobbledTracksList();
	void retrySubmit();

	void cacheSaved();
	void songAddedForSubmission(const QString&);
    void songAdded(const QString &artist, const QString &title, const QString &album, const QString &musicbrainzid, unsigned int length);
	void removeCurrentSong();
};

#endif // QSCROBBLER_H_INCLUDED
