/*
 * qscrobbleraddon.h
 *
 *  Created on: 01.03.2009
 *      Author: darkstar
 */

#ifndef QSCROBBLERADDON_H_
#define QSCROBBLERADDON_H_

#include "quasar.h"
#include "addonmanager.h"
#include "configuration.h"
#include "configurationdialog.h"

#include "helpers.h"
#include "kmdcodec.h"
#include "qscrobbler.h"
#include "audioscrobbler.h"
#include "qscrobblerconfig.h"

class QScrobblerAddOn : public AddOn
{
	Q_OBJECT
public:
	static QScrobblerAddOn& singleton();
#	define qScrobblerAddOn QScrobblerAddOn::singleton()

	QScrobblerAddOn()
		:	AddOn()
	{
		qDebug("Registering QScrobblerAddOn");
	}

	virtual ~QScrobblerAddOn()
	{
	}

	virtual void init()
	{
		scrobbler_ = new AudioScrobbler(this);
		scrobbler_->setSubmissionPaused(true);

		qscrobbler_ = NULL;
	}

	virtual void deinit()
	{
		delete scrobbler_;
	}

	virtual void hookMainWindow(Quasar *mainWindow)
	{
		mainWindow_ = mainWindow;

		int insertIndex = mainWindow->toolsMenu_->indexOf(mainWindow_->idToolsMenuRescanForCoverArt_) + 1;
		mainWindow->toolsMenu_->insertItem(tr("QScrobbler..."), this, SLOT(openQScrobbler()), 0, -1, insertIndex);

		connect(mainWindow, SIGNAL(playbackStarted(Media*)), this, SLOT(playbackStarted(Media*)));
		connect(mainWindow, SIGNAL(playbackStopped()), scrobbler_, SLOT(stop()));
		connect(mainWindow, SIGNAL(playbackPaused()), scrobbler_, SLOT(pause()));
		connect(mainWindow, SIGNAL(playbackUnpaused()), scrobbler_, SLOT(unpause()));
	}

	virtual void hookConfigurationDialog(ConfigurationDialog *cd)
	{
		cd_ = cd;

		QScrobblerConfig *cv = new QScrobblerConfig(cd->config(), cd);
		cd->initializeAndAddConfigViewTab(cv, cv, tr("QScrobbler"));

		connect(cd_, SIGNAL(settingDefaultSettings()),
				this, SLOT(setDefaultSettings()));
	}

	virtual void writeToConfig(Config &cf)
	{
		config_.write(cf);
	}

	virtual void readFromConfig(Config &cf)
	{
		config_.read(cf);
		updateScrobblerSettings();
	}

	QScrobblerConfiguration &config() { return config_; }

private slots:
	void openQScrobbler()
	{
		if (!qscrobbler_)
		{
			qscrobbler_ = new QScrobbler(scrobbler_);
			connect(qscrobbler_, SIGNAL(closing()), this, SLOT(closeQScrobbler()));
			loadWidgetPosition(qscrobbler_, qGlobalConfig.configFilename(), "QScrobbler");
		}

#ifdef QTOPIA
		qscrobbler_->showMaximized();
#else
		qscrobbler_->show();
		qscrobbler_->setWindowState(qscrobbler_->windowState() & ~WindowMinimized | WindowActive);
#endif
	}

	void closeQScrobbler()
	{
		config().setSubmissionPaused(scrobbler_->submissionPaused());
		saveWidgetPosition(qscrobbler_, qGlobalConfig.configFilename(), "QScrobbler");
		qscrobbler_ = NULL;
	}

	void setDefaultSettings()
	{

	}

	void playbackStarted(Media *media)
	{
		scrobbler_->play(media->artist(), media->title(), media->album(), "", media->length());
	}

private:

	void updateScrobblerSettings()
	{
		scrobbler_->setUsername(config_.username());
		scrobbler_->setMD5Password(config_.md5Password());
		scrobbler_->setCacheSaveInterval(config_.cacheSaveInterval());
		scrobbler_->setCacheFileName(qGlobalConfig.configPath() + "qscrobbler.cache");
		scrobbler_->setSubmissionPaused(config_.submissionPaused());
		scrobbler_->reinitialize();
	}

	Quasar *mainWindow_;

	ConfigurationDialog *cd_;

	QScrobblerConfiguration config_;
    AudioScrobbler *scrobbler_;

    QScrobbler *qscrobbler_;
};

#endif /* QSCROBBLERADDON_H_ */
