#ifndef EXTERNALSERVICES_H
#define EXTERNALSERVICES_H

#include <qobject.h>

class Media;

class ExternalServices : public QObject
{
	Q_OBJECT

public:
	static ExternalServices& singleton();
#	define qExternalServices ExternalServices::singleton()

	ExternalServices();
	virtual ~ExternalServices();

public slots:
	void playbackStarted(Media* media);
	void playbackStopped();

	void playbackSeekedToAbsoluteSeconds(int);

	void playbackPaused();
	void playbackUnpaused();

public:
	QString getTemporaryPlaybackStatusFileName();

private:
	Media *currentMedia_;

	void writeCurrentMediaStatusToFile(const QString &statusString);
	QString escapeString(const QString &in);
};

#endif	// EXTERNALSERVICES_H
