/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BATTERYPLUS_H_INCLUDED
#define BATTERYPLUS_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>

class QCopChannel;

class BatteryPlus : public QObject
{
	Q_OBJECT

public:
	static BatteryPlus& singleton();
#	define g_BatteryPlus BatteryPlus::singleton()

	bool isRunning() const { return isRunning_; }
	void setMode(const QString& modeName);
	QString currentMode() const { return currentMode_; }
	QString initialMode() const { return initialMode_; }
	QStringList allModes() const { return allModes_; }

protected:
	BatteryPlus(QObject *parent = 0, const char *name = 0);
	~BatteryPlus();

private slots:
	void confEntryRecived(const QCString&, const QByteArray&);

private:
	//! BatteryPlusアプレットのメニュー設定を読み出します。
	void readConf();

	bool isRunning_;			//!< BatteryPlusアプレットが動いているか
	QStringList allModes_;		//!< モード名のリスト
	QString initialMode_;		//!< 初期に選択されていたモード
	QString currentMode_;		//!< 現在選択されているモード

	QCopChannel *recvChannel_;
};

#endif // BATTERYPLUS_H_INCLUDED
