#!/bin/bash

TARGET="pdaXrom"
BINARY_NAME="quasar"

SCRIPT_FILENAME="`cd \`dirname \"$0\"\`; pwd`/`basename \"$0\"`"
DISTRO_ROOT=$(dirname "$SCRIPT_FILENAME")

source "$DISTRO_ROOT/makedistro-common.sh.in"

function prepareMakefile()
{
	qmake quasar-pdaxrom.pro > Makefile
}

buildBinary "$TOOLS_ROOT/devenv-arm-pdaxrom.sh"
copySkeletonBinaryAndSkins "$DISTRO_ROOT/skeletons/pdaxrom" "$INPUT_ROOT/usr/bin/quasar" "$INPUT_ROOT/usr/share/quasar/skins"

# copy images
IMAGE_ROOT="$INPUT_ROOT/usr/share/quasar/pics/quasar"
rm -f "$IMAGE_ROOT/"* > /dev/null 2>&1
cp "$DISTRO_ROOT/images/"* "$IMAGE_ROOT/"

removeObsoleteFiles

# create package
PACKAGE_FILENAME="$INPUT_ROOT/quasar.ipk"
insertVersionIntoFile "$INPUT_ROOT/CONTROL/control"
"$TOOLS_ROOT/ipkg-build" "$INPUT_ROOT" "$PACKAGE_FILENAME" || onError "Building IPKG failed."
movePackageToDestination "$PACKAGE_FILENAME" "$OUTPUT_ROOT/quasar_${APPVERSION_FILENAME_SUFFIX}_armv5tel.ipk" "$1"

cleanUp
