#ifndef UICONFIG_H
#define UICONFIG_H

#include "configview.h"
#include "configuration.h"

class QComboBox;
class QSpinBox;
class QCheckBox;

class UIConfig : public ConfigView
{
	Q_OBJECT
public:
	UIConfig(Configuration&, QWidget *parent = 0, const char *name = 0);
	virtual void setStatesByConfiguration(const Configuration&);

protected:
	virtual void createWidgets();

private slots:
	void setChangePlayInfoLayoutInPortaitMode(bool b)	{ config().changePlayInfoLayoutInPortaitMode = b; }
	void setPlaylistAutoTriggerFilterInterval(int value) { config().playlistAutoTriggerFilterInterval = value; }
	void setTouchModeEnabled(bool b)	{ config().isTouchModeEnabled = b; }
	void setKineticScrollingEnabled(bool b)	{ config().isKineticScrollingEnabled = b; }

	void setSkin1(const QString &skinName)	{ config().skin1 = skinName; }
	void findSkin1();

	void setSkin2(const QString &skinName)	{ config().skin2 = skinName; }
	void findSkin2();

private:
	QCheckBox *changePlayInfoLayoutInPortaitMode_;
	QCheckBox *touchModeEnabled_;
	QCheckBox *kineticScrollingEnabled_;
	QSpinBox *playlistAutoTriggerFilterInterval_;
	QComboBox *skinList1, *skinList2;
};

#endif	// UICONFIG_H
