/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CONFIGURATIONDIALOG_H_INCLUDED
#define CONFIGURATIONDIALOG_H_INCLUDED

#include <qtabdialog.h>
#include <qstring.h>
#include <qmap.h>

#include "configuration.h"
#include "configview.h"

class MPlayerConfig;
class FormatsConfig;
class GeneralConfig;
class HotKeyConfig;
class HotAreaConfig;
class UIConfig;
class CoverArtConfig;

class ConfigurationDialog: public QTabDialog
{
	Q_OBJECT

public:
	ConfigurationDialog(const Configuration&, QWidget *parent = 0, const char *name = 0);

	const Configuration& result() const { return workingConfiguration_; }

	Configuration& config() { return workingConfiguration_; }

	void initializeAndAddConfigViewTab(BaseConfigView *cv, QWidget *view, const QString &tabCaption);

	int exec();
	void showMPlayerConfig();

public:
	QList<BaseConfigView> configViews;

	GeneralConfig *generalConfig;
	MPlayerConfig *mplayerConfig;
	FormatsConfig *formatsConfig;
	HotKeyConfig *hotKeyConfig;
	HotAreaConfig *hotAreaConfig;
	UIConfig *uiConfig;
	CoverArtConfig *coverArtConfig;

public slots:
	void setDefaultSetting();

signals:
	void nukeMediaCacheButtonClicked();

	void settingStatesByConfiguration(const Configuration& config);
	void savingStatesToConfiguration();
	void settingDefaultSettings();

protected:
	void showEvent(QShowEvent *);

private:
	void createWidgets();
	void setStatesByConfiguration(const Configuration& config);
	void saveStatesToConfiguration();

	//! ダイアログで適用されるまで使われるConfigurationのコピー
	Configuration workingConfiguration_;
};

#endif // CONFIGURATIONDIALOG_H_INCLUDED
