951540<?php
include("CoverArtProviders.php");

header("Content-Type: text/plain");
$debugMode = $_GET['debug'] == 1;

$limit = 0;
if (isset($_GET['limit']) && is_numeric($_GET['limit']))
	$limit = (int)$_GET['limit'];

$testcases = array(
	array("Eluveitie", "Spirit"),
	array("Eluveitie", "Slania"),
	array("Megadeth", "Youthanasia"),
	array("Death Angel", "Killing Season"),
	array("Bruce Springsteen", "Devils And Dust"),
	array("Madonna", "Ray Of Light"),
	array("dZihan & Kamien", "Freaks And Icons")	
);

echo "Test and status of all album art providers\n";
echo "------------------------------------------\n\n";

// Print all testcases...
echo "Testcases:\n\n";
$i = 1;
foreach ($testcases as $testcase)
{
	echo sprintf("%3d : %25s - %-25s\n", $i, $testcase[0], $testcase[1]);
	++$i;
}

echo "\n\n";

// Print column header...
$colWidthCoverArtProvider = 32;
$colWidthImageURLsCount = 5;
$colWidthStatus = 10;

echo sprintf("%-" . $colWidthCoverArtProvider . "s%" . count($testcases) * $colWidthImageURLsCount . "s%" . $colWidthStatus . "s \n", "Album art provider name", "Image URLs for testcase", "Status");
echo sprintf("%-" . $colWidthCoverArtProvider . "s", "");

for ($i = 1; $i <= count($testcases); ++$i)
	echo sprintf("%" . $colWidthImageURLsCount . "d", $i);
	
echo "\n\n";

// Print one line per album art provider...
$testResults = array();

foreach ($globalCoverArtProviders as $provider)
{
	echo sprintf("%-" . $colWidthCoverArtProvider . "s", $provider->name());
	flush();
		
	$imageURLsCount = array();
	
	$testcaseNo = 1;
	foreach ($testcases as $testcase)
	{
		$coverArtList = $provider->getCoverArtList($testcase[0], $testcase[1], $limit);
		$coverArtList->artist = $testcase[0];
		$coverArtList->album = $testcase[1];

		$testResults[$provider->name][$testcaseNo] = $coverArtList;
		
		$count = count($coverArtList->results);
		$imageURLsCount[] = $count;
		echo sprintf("%" . $colWidthImageURLsCount . "d", $count);
		
		++$testcaseNo;
		flush();
	}
	
	if (array_sum($imageURLsCount) == 0)
		echo sprintf("%" . $colWidthStatus . "s", "FAIL!");
	else
		echo sprintf("%" . $colWidthStatus . "s", "OK");
	
	echo "\n";
	
	flush();
}

echo "\n";
echo "Finished!\n\n";

echo "Details:\n\n";
print_r($testResults);

?>