/*
 * config.cpp
 *
 *  Created on: 03.04.2010
 *      Author: darkstar
 */

#include <config.h>

Config::Config(const QString &name, Domain domain)
	:	QSettings(name, QSettings::IniFormat)
{

}

bool Config::hasKey(const QString &key) const
{
	return contains(key);
}

bool Config::isValid() const
{
	return status() == QSettings::NoError;
}

void Config::setGroup(const QString &gname)
{
	while (!group().isEmpty())
		endGroup();

	if (!gname.isEmpty())
		beginGroup(gname);
}

void Config::writeEntry(const QString &key, const QVariant &value)
{
	setValue(key, value);
}

void Config::writeEntry(const QString &key, const QStringList &lst, const QChar &sep)
{
	QString entry = lst.join(sep);
	setValue(key, entry);
}

QString Config::readEntry(const QString &key, const QString &defaultValue) const
{
	return value(key, defaultValue).toString();
}

int Config::readNumEntry(const QString &key, int defaultValue) const
{
	return value(key, defaultValue).toInt();
}

bool Config::readBoolEntry(const QString &key, bool defaultValue) const
{
	return value(key, defaultValue).toBool();
}

QStringList Config::readListEntry(const QString &key, const QChar &sep) const
{
	QVariant val = value(key);
	if (val.canConvert<QString>())
	{
		QString entry(val.value<QString>());
		QStringList list(entry.split(sep, QString::KeepEmptyParts));
		return list;
	}
	else if (val.canConvert<QStringList>())
		return val.toStringList();
	else
		return QStringList();
}
