/*
 * config.h
 *
 *  Created on: 03.04.2010
 *      Author: darkstar
 */

#ifndef CONFIG_H_
#define CONFIG_H_

#include <QSettings>

class Config : public QSettings
{
	Q_OBJECT;
public:
	enum Domain {File, User};
	Config(const QString &name, Domain domain = User);

        bool hasKey(const QString &key) const;
        bool isValid() const;
        void setGroup(const QString &gname);

        void writeEntry(const QString &key, const QVariant &value);
        void writeEntry(const QString &key, const QStringList &lst, const QChar &sep);
        QString readEntry(const QString &key, const QString &defaultValue = QString::null) const;

        int readNumEntry(const QString &key, int defaultValue = -1) const;
        bool readBoolEntry(const QString &key, bool defaultValue = FALSE) const;
        QStringList readListEntry(const QString &key, const QChar &sep) const;
};

#endif /* CONFIG_H_ */
