/*
 * addonmanager.cpp
 *
 *  Created on: 26.02.2009
 *      Author: darkstar
 */

#include "addonmanager.h"

/* AddOn */

AddOn::AddOn()
	:	QObject()
{
	qAddOnManager.registerAddOn(this);
}

AddOn::~AddOn()
{
	qAddOnManager.unregisterAddOn(this);
}

/* AddOnManager */

AddOnManager &AddOnManager::singleton()
{
	static AddOnManager instance;
	return instance;
}

AddOnManager::AddOnManager()
{
#ifdef QT4
	addOns_ = new QList<AddOn *>();
#else
	addOns_ = new QList<AddOn>();
#endif
}

AddOnManager::~AddOnManager()
{
	for (int i = addOns_->count() - 1; i >= 0; --i)
	{
		unregisterAddOn(addOns_->at(i));
	}

	delete addOns_;
}

void AddOnManager::registerAddOn(AddOn *addOn)
{
	addOns_->append(addOn);
	addOn->addOnManager_ = this;
	qDebug("registerAddOn %p", addOn);
}

bool AddOnManager::unregisterAddOn(AddOn *addOn)
{
	qDebug("unregisterAddOn %p", addOn);

	addOn->addOnManager_ = 0;
#ifdef QT4
	return addOns_->removeAll(addOn);
#else
	return addOns_->removeRef(addOn);
#endif
}

void AddOnManager::hookMainWindow(Quasar *mainWindow)
{
	for (int i = 0; i < addOns_->count(); ++i)
		 addOns_->at(i)->hookMainWindow(mainWindow);
}

void AddOnManager::hookPlayListView(PlayListView *playList)
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->hookPlayListView(playList);
}

void AddOnManager::hookConfigurationDialog(ConfigurationDialog *cd)
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->hookConfigurationDialog(cd);
}

void AddOnManager::writeToConfig(Config &cf)
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->writeToConfig(cf);
}

void AddOnManager::readFromConfig(Config &cf)
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->readFromConfig(cf);
}

void AddOnManager::init()
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->init();
}

void AddOnManager::deinit()
{
	for (int i = 0; i < addOns_->count(); ++i)
		addOns_->at(i)->deinit();
}
