/*
 * addonmanager.h
 *
 *  Created on: 26.02.2009
 *      Author: darkstar
 */

#ifndef ADDONMANAGER_H_
#define ADDONMANAGER_H_

#ifdef QT4
#include <QObject>
#include <QList>
#else
#include <qobject.h>
#include <qlist.h>
#endif

#ifdef QTOPIA
#include <qpe/config.h>
#else
#include <config.h>
#endif

class AddOnManager;
class PlayListView;
class Quasar;
class ConfigurationDialog;

class AddOn: public QObject
{
public:
	AddOn();
	virtual ~AddOn();

	virtual void hookMainWindow(Quasar *mainWindow) {}
	virtual void hookPlayListView(PlayListView *playList) {}
	virtual void hookConfigurationDialog(ConfigurationDialog *cd) {}

	virtual void writeToConfig(Config &cf) {}
	virtual void readFromConfig(Config &cf) {}

	virtual void init() {}
	virtual void deinit() {}

	AddOnManager *addOnManager() { return addOnManager_; }

private:
	friend class AddOnManager;
	AddOnManager *addOnManager_;
};

class AddOnManager
{
public:
	static AddOnManager& singleton();
#	define qAddOnManager AddOnManager::singleton()

	AddOnManager();
	virtual ~AddOnManager();

	void registerAddOn(AddOn *addOn);
	bool unregisterAddOn(AddOn *addOn);

	virtual void hookMainWindow(Quasar *mainWindow);
	virtual void hookPlayListView(PlayListView *playList);
	virtual void hookConfigurationDialog(ConfigurationDialog *cd);

	virtual void writeToConfig(Config &cf);
	virtual void readFromConfig(Config &cf);

	virtual void init();
	virtual void deinit();

private:
#ifdef QT4
	QList<AddOn *> *addOns_;
#else
	QList<AddOn> *addOns_;
#endif
};

#endif /* ADDONMANAGER_H_ */
