/*
 * playlistaspectalbumgroupbuilder.cpp
 *
 *  Created on: 19.06.2010
 *      Author: darkstar
 */

#include "playlistaspectalbumgroupbuilder.h"
#include "coverartimageprovider.h"

#include "sqlite3.h"
#include "debug.h"

#include "compathack.h"

PlayListAspectAlbumGroupBuilder::PlayListAspectAlbumGroupBuilder()
	:	QObject(),
		PlayListAspectExtension(),
		users_(),
		groupItems_(),
		playlistIDLookupDict_(),
		selectedIndex_(0)
{
#ifndef QT4
	groupItems_.setAutoDelete(true);
#endif
}

PlayListAspectAlbumGroupBuilder::~PlayListAspectAlbumGroupBuilder()
{
	reset();
}

const QString PlayListAspectAlbumGroupBuilder::identifier()
{
	return playListAspect()->prefix() + "albumgroupbuilder";
}

void PlayListAspectAlbumGroupBuilder::registerUser(void *user)
{
	bool activeBefore = isActive();

#ifdef QT4
	if (!users_.contains(user))
		users_.append(user);
#else
	if (!users_.containsRef(user))
		users_.append(user);
#endif

	if (!activeBefore)
		update();
}

void PlayListAspectAlbumGroupBuilder::unregisterUser(void *user)
{
#ifdef QT4
	users_.removeOne(user);
#else
	users_.removeRef(user);
#endif
}

bool PlayListAspectAlbumGroupBuilder::isActive()
{
	return users_.count() > 0;
}

void PlayListAspectAlbumGroupBuilder::execute()
{
	DENTERMETHOD;

	if (isActive())
	{
		reset();

		DTIMERINIT(timer);

		QString query =
			"SELECT artist, media_location.location || media.filename FROM media "
			"LEFT JOIN media_location ON media_location.location_id = media.location_id "
			"WHERE media_id = ?1;";

		sqlite3_stmt *vm2;
		sqlite3_prepare_v2(playListAspect()->playList()->mediaDatabase()->db(), query.toUtf8(), -1, &vm2, 0);

		playListAspect()->playList()->mediaDatabase()->dbDebug(query);

		query = "SELECT playlist_id, media_id, album FROM " + dbSafeString(inputViewSource()) + ";";
		sqlite3_stmt *vm;
		sqlite3_prepare_v2(playListAspect()->playList()->mediaDatabase()->db(), query.toUtf8(), -1, &vm, 0);

		playListAspect()->playList()->mediaDatabase()->dbDebug(query);

		GroupItem *item = NULL;

		QString previousAlbum = QString::null;

		while (sqlite3_step(vm) == SQLITE_ROW)
		{
			QString currentAlbum = QString::fromUtf8((const char *)sqlite3_column_text(vm, 2));
			unsigned long playlistID = sqlite3_column_int(vm, 0);

			// Build groups by album
			if (previousAlbum != currentAlbum)
			{
				unsigned long mediaID = sqlite3_column_int(vm, 1);
				sqlite3_bind_int(vm2, 1, mediaID);

				if (sqlite3_step(vm2) == SQLITE_ROW)
				{
					item = new GroupItem();

					item->playlistID = playlistID;
					item->album = currentAlbum;
					item->artist = QString::fromUtf8((const char *)sqlite3_column_text(vm2, 0));
					item->key = CoverArtImageProvider::createKey(item->artist, currentAlbum);
					item->filename = QString::fromUtf8((const char *)sqlite3_column_text(vm2, 1));

					groupItems_.append(item);

					previousAlbum = currentAlbum;
				}

				sqlite3_reset(vm2);
			}

	#ifdef QT4
			if (groupItems_.count() > 1)
				playlistIDLookupDict_.insert(playlistID, (unsigned long)(groupItems_.count() - 1));
	#else
			if (groupItems_.count() > 1)
				playlistIDLookupDict_.insert(playlistID, (unsigned long *)(groupItems_.count() - 1));
	#endif
		}

		sqlite3_finalize(vm);
		sqlite3_finalize(vm2);

		emit updateView();

		DTIMERPRINT(timer, "Grouping albums...");
	}

	DEXITMETHOD;
}

void PlayListAspectAlbumGroupBuilder::reset()
{
#ifdef QT4
	qDeleteAll(groupItems_);
#endif
	groupItems_.clear();
	playlistIDLookupDict_.clear();
}

void PlayListAspectAlbumGroupBuilder::saveExtensionState(QStringList &dst)
{
	// TODO To be implemented...
}

void PlayListAspectAlbumGroupBuilder::loadExtensionState(QStringList &src)
{
	// TODO To be implemented...
}

uint PlayListAspectAlbumGroupBuilder::groupIndexForPlayListID(const uint playListID)
{
	return (long)playlistIDLookupDict_[playListID];
}

GroupItem *PlayListAspectAlbumGroupBuilder::groupItemForPlayListID(const uint playListID)
{
	uint index = groupIndexForPlayListID(playListID);
	if (index > -1)
		return groupItems_.at(index);
	else
		return NULL;
}
