/*
 * playlistaspectalbumgroupbuilder.h
 *
 *  Created on: 19.06.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECTALBUMGROUPBUILDER_H_
#define PLAYLISTASPECTALBUMGROUPBUILDER_H_

#ifdef QT4
#include <QHash>
#include <QPixmap>
#include <QMouseEvent>
#else
#include <qintdict.h>
#endif

#include "playlistaspect.h"

class GroupItem
{
public:
	unsigned long playlistID;
	QString key;
	QString filename;
	QString artist;
	QString album;
};

#ifdef QT4
typedef QList<GroupItem *> GroupItemList;
#else
typedef QList<GroupItem> GroupItemList;
#endif

#ifdef QT4
typedef QList<void *> UserList;
#else
typedef QList<void> UserList;
#endif

class PlayListAspectAlbumGroupBuilder: public QObject, public PlayListAspectExtension
{
	Q_OBJECT
public:
	PlayListAspectAlbumGroupBuilder();
	virtual ~PlayListAspectAlbumGroupBuilder();

	virtual void reset();
	virtual const QString outputViewSource() { return inputViewSource(); }; // pass-through mode!
	virtual const QString identifier();

	void registerUser(void *user);
	void unregisterUser(void *user);
	virtual bool isActive();
	virtual bool isFiltering() { return false; }

	int selectedIndex() { return selectedIndex_; }
	void setSelectedIndex(int index) { selectedIndex_ = index; }

	uint groupIndexForPlayListID(const uint playListID);
	GroupItem *groupItemForPlayListID(const uint playListID);

	GroupItemList &groups() { return groupItems_; }

	void saveExtensionState(QStringList &dst);
	void loadExtensionState(QStringList &src);

signals:
	void updateView();

protected:
	virtual void execute();

private:
	UserList users_;
	GroupItemList groupItems_;
#ifdef QT4
	QHash<int, unsigned long> playlistIDLookupDict_;
#else
	QIntDict<unsigned long> playlistIDLookupDict_;
#endif
	int selectedIndex_;
};

#endif /* PLAYLISTASPECTALBUMGROUPBUILDER_H_ */
