/*
 * playlistaspectlistviewrenderer.cpp
 *
 *  Created on: 24.04.2010
 *      Author: darkstar
 */

#include "playlistaspectlistviewrenderer.h"
#include "sqlite3.h"
#include "debug.h"
#include "compathack.h"

/* PlayListItem */

Media *PlayListItem::getAndSetMedia() const
{
	// This is bad, but this hack reduces the complexity for the fast path above...
	PlayListItem *self = const_cast<PlayListItem *>(this);
	self->media_ = mediaDatabase_->media(mediaID_);
	media_->registerListener(self);
	return media_;
}


/* PlayListAspectListViewRenderer */

PlayListAspectListViewRenderer::PlayListAspectListViewRenderer()
	:	QObject(),
		PlayListAspectExtension(),
	 	isSorted_(false),
	 	isSortAscending_(false),
	 	sortedColumn_(0),
		selectedItemIndex_(0),
		viewportPosition_(0, 0),
		forceSelectedItemIndex_(false),
	 	itemListRequiresUpdate_(true)
{
#ifndef QT4
	items_.setAutoDelete(true);
#endif
}

PlayListAspectListViewRenderer::~PlayListAspectListViewRenderer()
{
	clearPlayListItemList(&items_);
}

const QString PlayListAspectListViewRenderer::outputViewSource()
{
	return playListAspect()->prefix() + "listview_sorted";
}

void PlayListAspectListViewRenderer::reset()
{
	DENTERMETHOD;
	setSortParams(PlayListAspectListViewRenderer::COLUMN_NONE);
	DEXITMETHOD;
}

void PlayListAspectListViewRenderer::execute()
{
	DENTERMETHOD;

	DTIMERINIT(time);

	QString query = "SELECT playlist_id, media_id, track, title, album, artist FROM " + dbSafeString(inputViewSource()) + " ";

	if (isSorted_)
	{
		QString direction = isSortAscending_ ? "ASC" : "DESC";

		if (sortedColumn_ == 1)
			query += "ORDER BY track " + direction;
		else if (sortedColumn_ == 2)
			query += "ORDER BY title " + direction;
		else if (sortedColumn_ == 3)
			query += "ORDER BY artist " + direction + ", album, track";
		else if (sortedColumn_ == 4)
			query += "ORDER BY album " + direction + ", track";
		else if (sortedColumn_ == 5)
			query += "ORDER BY playtime " + direction;
	}
	else
		query += "ORDER BY idx ASC";

	query += ";";

	QString sourceViewName = outputViewSource();

	QString query2 = "DROP VIEW IF EXISTS " + dbSafeString(sourceViewName) + ";";
	sqlite3_exec(playListAspect()->playList()->mediaDatabase()->db(), query2.toUtf8(), NULL, NULL, NULL);
	DOP(playListAspect()->playList()->mediaDatabase()->dbDebug(query2));

	query = "CREATE TEMPORARY VIEW " + dbSafeString(sourceViewName) + " AS " + query;
	sqlite3_exec(playListAspect()->playList()->mediaDatabase()->db(), query.toUtf8(), NULL, NULL, NULL);
	DOP(playListAspect()->playList()->mediaDatabase()->dbDebug(query));

	playListAspect()->playList()->mediaDatabase()->ensurePreparedStatementsAreValid();

	DTIMERPRINT(time, "loadFromViewSource create view");

	itemListRequiresUpdate_ = true;

	DPRINTF("Emitting updateView()...");
	emit updateView();

	DEXITMETHOD;
}

void PlayListAspectListViewRenderer::extensionGraphExecutionStarted(bool &stopIt)
{
	emit graphExecutionStarted(stopIt);
}

void PlayListAspectListViewRenderer::setSelectedItemIndex(int index)
{
	if (index != selectedItemIndex_ && index > -1 && index < items_.count())
		selectedItemIndex_ = index;
}

PlayListItemList *PlayListAspectListViewRenderer::itemList()
{
	if (itemListRequiresUpdate_)
		updateItemList();

	return &items_;
}

void PlayListAspectListViewRenderer::setItemList(PlayListItemList &itemList)
{
	if (!isGraphFiltered())
	{
		playListAspect()->playList()->storeItemList(itemList);
	}
}

void PlayListAspectListViewRenderer::updateItemList()
{
	QString query = "SELECT playlist_id, media_id FROM " + dbSafeString(outputViewSource()) + ";";

	PlayListItem *curItem = NULL;
	unsigned long curItemID = 0;

	if (!forceSelectedItemIndex_)
	{
		// Get playlist ID of previously selected item in list...
		if (selectedItemIndex_ > -1 && selectedItemIndex_ < items_.count())
			curItemID = items_.at(selectedItemIndex_)->id();

		selectedItemIndex_ = -1;
	}

	DTIMERINIT(time);
	sqlite3_stmt *vm;
	sqlite3_prepare_v2(playListAspect()->playList()->mediaDatabase()->db(), query.toUtf8(), -1, &vm, 0);

	DOP(playListAspect()->playList()->mediaDatabase()->dbDebug(query));

	DTIMERPRINT(time, "updateItemList query");

	DTIMERSTART(time);
	clearPlayListItemList(&items_);

	MediaDatabase *mediaDatabase = playListAspect()->playList()->mediaDatabase();

	PlayListItem *item = NULL;

	while (sqlite3_step(vm) == SQLITE_ROW)
	{
		item = new PlayListItem(sqlite3_column_int(vm, 1), sqlite3_column_int(vm, 0), mediaDatabase);
		items_.append(item);

		// Reselect item with new index...
		if (selectedItemIndex_ == -1 && item->id() == curItemID)
			selectedItemIndex_ = items_.count() - 1;
	}

	if (selectedItemIndex_ > -1 && selectedItemIndex_ > items_.count() - 1)
		selectedItemIndex_ = -1;

	DOP(playListAspect()->playList()->mediaDatabase()->dbDebug("data"));

	DTIMERPRINT(time, "updateItemList t update");

	sqlite3_finalize(vm);

	forceSelectedItemIndex_ = false;
	itemListRequiresUpdate_ = false;
}

void PlayListAspectListViewRenderer::setSortParams(int column, bool ascending)
{
	DENTERMETHOD;

	// record sorted section and sort direction...
	sortedColumn_ = column;
	isSortAscending_ = ascending;
	isSorted_ = column != 0;

	update();

	DEXITMETHOD;
}

void PlayListAspectListViewRenderer::saveExtensionState(QStringList &dst)
{
	dst.append("sortedColumn:" + QString::number(sortedColumn_));
	dst.append("sortAscending:" + (isSortAscending_ ? QString::number(1) : QString::number(0)));
	dst.append("selectedItemIndex:" + QString::number(selectedItemIndex_));
	dst.append("viewportPositionX:" + QString::number(viewportPosition_.x()));
	dst.append("viewportPositionY:" + QString::number(viewportPosition_.y()));
}

void PlayListAspectListViewRenderer::loadExtensionState(QStringList &src)
{
	if (src.count() == 5)
	{
		sortedColumn_ = src[0].mid(src[0].indexOf(":") + 1).toInt();
		isSortAscending_ = src[1].mid(src[1].indexOf(":") + 1) == "1";
		setSortParams(sortedColumn_, isSortAscending_);
		selectedItemIndex_ = src[2].mid(src[2].indexOf(":") + 1).toInt();
		forceSelectedItemIndex_ = true;
		viewportPosition_.setX(src[3].mid(src[3].indexOf(":") + 1).toInt());
		viewportPosition_.setY(src[4].mid(src[4].indexOf(":") + 1).toInt());
	}
}
