/*
 * playlistaspectlistviewrenderer.h
 *
 *  Created on: 24.04.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECTLISTVIEWRENDERER_H_
#define PLAYLISTASPECTLISTVIEWRENDERER_H_

#include <qpoint.h>

#include "playlist.h"
#include "playlistaspect.h"
#include "media.h"

class PlayListAspectListViewRenderer: public QObject, public PlayListAspectExtension
{
	Q_OBJECT
public:
	enum Columns {
		COLUMN_NONE = 0,
		COLUMN_TRACKNO = 1,
		COLUMN_TITLE = 2,
		COLUMN_ARTIST = 3,
		COLUMN_ALBUM = 4,
		COLUMN_LENGTH = 5,
		COLUMN_MAX = 6
	};

	PlayListAspectListViewRenderer();
	virtual ~PlayListAspectListViewRenderer();

	virtual void reset();
	virtual const QString outputViewSource();

	virtual bool isActive() { return true; }
	virtual bool isFiltering() { return isSorted_; }

	virtual void saveExtensionState(QStringList &dst);
	virtual void loadExtensionState(QStringList &src);

	int sortedColumn() { return sortedColumn_; }
	bool isSortAscending() { return isSortAscending_; }
	void setSortParams(int column, bool ascending = TRUE);
	void resetSorting();
	bool isSorted() { return isSorted_; };

	int selectedItemIndex() { return selectedItemIndex_; }
	void setSelectedItemIndex(int index);

	QPoint viewportPosition() { return viewportPosition_; }
	void setViewportPosition(QPoint pos) { viewportPosition_ = pos; }

	PlayListItemList *itemList();
	void setItemList(PlayListItemList &itemList);

signals:
	void updateView();
	void graphExecutionStarted(bool &stopIt);

protected:
	virtual void execute();
	virtual void extensionGraphExecutionStarted(bool &stopIt);

private:
 	bool isSorted_;
 	bool isSortAscending_;
 	int sortedColumn_;
	int selectedItemIndex_;
	QPoint viewportPosition_;

	bool forceSelectedItemIndex_;
	bool itemListRequiresUpdate_;
	PlayListItemList items_;

 	void updateItemList();
};

#endif /* PLAYLISTASPECTLISTVIEWRENDERER_H_ */
