/*
 * playlistaspectoverviewfilter.h
 *
 *  Created on: 20.04.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECTOVERVIEWFILTER_H_
#define PLAYLISTASPECTOVERVIEWFILTER_H_

#include "playlistaspect.h"

class OverviewFilterListEntry
{
public:
	OverviewFilterListEntry(const QString &text, bool selected)
		:	text(text), selected(selected) {}

	QString text;
	bool selected;
};

#ifdef QT4
typedef QList<OverviewFilterListEntry *> OverviewFilterList;
#else
typedef QList<OverviewFilterListEntry> OverviewFilterList;
#endif

#ifdef QT4
typedef QList<void *> UserList;
#else
typedef QList<void> UserList;
#endif

class PlayListAspectOverviewFilter: public QObject, public PlayListAspectExtension
{
	Q_OBJECT
public:
	PlayListAspectOverviewFilter();
	virtual ~PlayListAspectOverviewFilter();

	virtual void reset();
	virtual const QString outputViewSource();
	virtual const QString identifier();

	virtual bool isActive();
	virtual bool isFiltering();

	void registerUser(void *user);
	void unregisterUser(void *user);

	virtual void loadExtensionState(QStringList &src);
	virtual void saveExtensionState(QStringList &dst);

	OverviewFilterList &genreList() { return genreList_; }
	void updateFromGenreList();
	OverviewFilterList &artistList() { return artistList_; }
	void updateFromArtistList();
	OverviewFilterList &albumList() { return albumList_; }
	void updateFromAlbumList();

signals:
	void updatedGenreList();
	void updatedArtistList();
	void updatedAlbumList();

protected:
	virtual void execute();

private:
	enum UpdateStartingPoint {
		Input = 0,
		GenreList = 1,
		ArtistList = 2,
		AlbumList = 3
	};

	UserList users_;
	bool isDirty_;
	UpdateStartingPoint updateFrom_;

	OverviewFilterList genreList_;
	OverviewFilterList artistList_;
	OverviewFilterList albumList_;

	bool updatingGenres_;
	bool updatingArtists_;
	bool updatingAlbums_;

	QString selectedGenresFilter;
	QString selectedArtistsFilter;
	QString selectedAlbumsFilter;

	int selectionCount(OverviewFilterList &list);
	QString buildFilter(OverviewFilterList &list, const QString &textForUnknownEntry);
	void createFilteredTable(const QString &selectedFilter, const QString &srctable, const QString &dsttable, const QString &what, const QString &wherecol);
	void doUpdateOnList(OverviewFilterList &list, const QString &selectedFilter, const QString &colname, const QString &srctable, const QString &unknown, const QString &one, const QString &more);

	void updateFilterFromInput();
	void updateFilterFromGenreList();
	void updateFilterFromArtistList();
	void updateFilterFromAlbumList();
};

#endif /* PLAYLISTASPECTOVERVIEWFILTER_H_ */
