/*
 * playlistaspectsearchfilter.h
 *
 *  Created on: 18.04.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECTSEARCHFILTER_H_
#define PLAYLISTASPECTSEARCHFILTER_H_

#include "playlistaspect.h"

class PlayListAspectSearchFilter;

class MediaNGramIndexManager: public QObject
{
	Q_OBJECT
public:
	MediaNGramIndexManager(MediaDatabase *mediaDatabase);
	virtual ~MediaNGramIndexManager();

	void attach(PlayListAspectSearchFilter *filter);
	void remove(PlayListAspectSearchFilter *filter);
	int filterCount() { return list_.count(); }

	static QString removeDiacritics(const QString &input);
	static QString removePunctuations(const QString &input);
	static QStringList tokenizeString(const QString &input);
	static void reorderTokensByLength(QStringList &tokenList);
	static void createNGrams(const QString &inputWord, QStringList &outputList, int gramSize = 3, bool padLeft = true, bool padRight = true);

private slots:
	void mediaDatabasePreparingStatements(sqlite3 *);
	void mediaDatabaseFinalizingStatements(sqlite3 *);
	void mediaDatabaseMediaUpdated(Media *);

private:
	MediaDatabase *mediaDatabase_;

	sqlite3_stmt *stmtInsertNGramIndex_;
	sqlite3_stmt *stmtInsertTokenIndex_;

	PlayListAspectExtensionList list_;

	void tokenizeGrammifyAndInsert(const QString &input, const unsigned long mediaID, const int gramSize = 3);

	void createSchema();
	bool nGramIndexExists();
	void recreateNGramIndex(const int gramSize = 3);
};

class PlayListAspectSearchFilter: public QObject, public PlayListAspectExtension
{
	Q_OBJECT
public:
	PlayListAspectSearchFilter();
	virtual ~PlayListAspectSearchFilter();

	virtual void reset();
	virtual const QString outputViewSource();
	virtual bool isActive() { return isFiltering(); };
	virtual bool isFiltering() { return filterText_ != ""; }

	void setFilterText(const QString &filter);
	const QString &filterText() { return filterText_; }

	void saveExtensionState(QStringList &dst);
	void loadExtensionState(QStringList &src);

protected:
	virtual void attachedToAspect();
	virtual void removedFromAspect();

	virtual void execute();

private:
	QString filterText_;
	QString dbFilterText_;

	bool nGramSearchEnabled_;

	void naiveTextSearch(const QString &inputView, const QString &outputView, const QString &searchString);
	void nGramTextSearch(const QString &inputView, const QString &outputView, const QString &searchString);
};

#endif /* PLAYLISTASPECTSEARCHFILTER_H_ */
