/*
 * playlistaspectstatisticsgatherer.cpp
 *
 *  Created on: 20.04.2010
 *      Author: darkstar
 */

#include "playlistaspectstatisticsgatherer.h"
#include "helpers.h"
#include "debug.h"

PlayListAspectStatisticsGatherer::PlayListAspectStatisticsGatherer()
	:	QObject(),
	 	PlayListAspectExtension(),
		totalPlaytime_(0),
		totalFilesize_(0),
		itemCount_(0)
{

}

PlayListAspectStatisticsGatherer::~PlayListAspectStatisticsGatherer()
{

}

const QString PlayListAspectStatisticsGatherer::identifier()
{
	return playListAspect()->prefix() + "statistics";
}

void PlayListAspectStatisticsGatherer::execute()
{
	DENTERMETHOD;
	DTIMERINIT(ptfs);

	sqlite3_stmt *vm;
	QString query = "SELECT SUM(playtime), SUM(filesize), COUNT(filesize) FROM " + dbSafeString(inputViewSource()) + ";";
	sqlite3_prepare_v2(playListAspect()->playList()->mediaDatabase()->db(), query, -1, &vm, 0);
	if (sqlite3_step(vm) == SQLITE_ROW)
	{
		totalPlaytime_ = sqlite3_column_int64(vm, 0);
		totalFilesize_ = sqlite3_column_int64(vm, 1);
		itemCount_ = sqlite3_column_int64(vm, 2);
	}
	sqlite3_finalize(vm);

	DTIMERINIT(temp);
	emit statisticsUpdated(displayText());
	DTIMERPRINT(temp, "emit statisticsUpdated();");

	DTIMERPRINT(ptfs, "totalPlaytime, totalFilesize");
	DEXITMETHOD;
}

QString PlayListAspectStatisticsGatherer::displayText()
{
	if (itemCount_ == 0)
		return tr("No titles found.");
	else
	{
		QString filesizeDisplay = formatFileSize(totalFilesize_);
		QString timeDisplay = formatPlayTime(totalPlaytime_);

		if (itemCount_ == 1)
			return QString(tr("%1 title, %2, %3")).arg(itemCount_).arg(timeDisplay).arg(filesizeDisplay);
		else
			return QString(tr("%1 titles, %2, %3")).arg(itemCount_).arg(timeDisplay).arg(filesizeDisplay);
	}
}
