/*
 * playlistaspectstatisticsgatherer.h
 *
 *  Created on: 20.04.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECTSTATISTICSGATHERER_H_
#define PLAYLISTASPECTSTATISTICSGATHERER_H_

#include "playlistaspect.h"

class PlayListAspectStatisticsGatherer: public QObject, public PlayListAspectExtension
{
	Q_OBJECT
public:
	PlayListAspectStatisticsGatherer();
	virtual ~PlayListAspectStatisticsGatherer();

	virtual const QString outputViewSource() { return inputViewSource(); } // pass-through mode!
	virtual const QString identifier();

	long long totalPlaytime() { return totalPlaytime_; };
	long long totalFileSize() { return totalFilesize_; };
	int itemCount() { return itemCount_; }

	QString displayText();

signals:
	void statisticsUpdated(const QString &displayText);

protected:
	virtual void execute();

private:
	long long totalPlaytime_;
	long long totalFilesize_;
	int itemCount_;
};

#endif /* PLAYLISTASPECTSTATISTICSGATHERER_H_ */
