/*
 * coverartimageprovider.cpp
 *
 *  Created on: 11.06.2010
 *      Author: darkstar
 */

#ifdef QT4
#include <classcompathack.h>
#endif

#include "coverartimageprovider.h"
#include "debug.h"

#include "compathack.h"

/* CoverArtImageProvider */

CoverArtImageProvider::CoverArtImageProvider(QObject *owner)
	:	ReflectionImageProvider(owner)
{

}

QImage* CoverArtImageProvider::threadedCreateImage(CachedImage *cachedImage)
{
	DENTERMETHOD;

	QImage srcImage;
	QImage *dstImage = NULL;

	GroupItem *item = static_cast<GroupItem *>(cachedImage->data());

	DPRINTF("CoverArtItem '%s' - '%s' - '%s' ", (const char *)(item->artist.utf8()), (const char *)(item->album.utf8()), (const char *)(item->filename.utf8()));

	bool imageWasLoaded = gCoverArtProvider.loadCoverDirectly(srcImage, item->artist, item->album, item->filename);

	if (imageWasLoaded && !srcImage.isNull())
	{
		DMEMSTAT();

		DPRINTF("Scaling image '%s'...", (const char *)(cachedImage->name().utf8()));

		QImage scaledImage = prepareImage(srcImage, refSize().width(), refSize().height() - reflectionHeight(), reflectionHeight());

		DPRINTF("Assigning scaled image '%s'...", (const char *)(cachedImage->name().utf8()));
		dstImage = new QImage(scaledImage);
	}
	else
		DPRINTF("Failed loading image '%s'", (const char *)(cachedImage->name().utf8()));

	DEXITMETHOD;

	return dstImage;
}

void CoverArtImageProvider::initializeCachedImage(CachedImage *cachedImage)
{
	GroupItem *item = static_cast<GroupItem *>(cachedImage->data());
	GroupItem *newItem = new GroupItem();

	// Clone item
	*newItem = *item;

	cachedImage->setData(newItem);
}

void CoverArtImageProvider::finalizeCachedImage(CachedImage *cachedImage)
{
	// Delete cloned item
	delete static_cast<GroupItem *>(cachedImage->data());
}

QString CoverArtImageProvider::createKey(const QString &artist, const QString &album)
{
	return artist.toLower() + " - " + album.toLower();
}

GroupItem CoverArtImageProvider::createGroupItemFromMedia(const Media &info)
{
	GroupItem result;
	result.playlistID = 0;
	result.album = info.album();
	result.artist = info.artist();
	result.key = createKey(info.artist(), info.album());
	result.filename = info.location().toString();
	return result;
}
