/*
 * coverartimageprovider.h
 *
 *  Created on: 11.06.2010
 *      Author: darkstar
 */

#ifndef COVERARTIMAGEPROVIDER_H_
#define COVERARTIMAGEPROVIDER_H_

#include "media.h"
#include "coverartprovider.h"
#include "reflectionimageflow.h"
#include "playlistaspectalbumgroupbuilder.h"

const int SlideWidthHeight = 300;
const int ReflectionHeight = (int)((float)SlideWidthHeight * 0.8);

class CachedImage;

class CoverArtImageProvider : public ReflectionImageProvider
{
	Q_OBJECT
public:
	CoverArtImageProvider(QObject *owner);

	static QString createKey(const QString &artist, const QString &album);
	static GroupItem createGroupItemFromMedia(const Media &info);

protected:
	virtual QImage* threadedCreateImage(CachedImage *cachedImage);
	virtual void initializeCachedImage(CachedImage *cachedImage);
	virtual void finalizeCachedImage(CachedImage *cachedImage);
};


#endif /* COVERARTIMAGEPROVIDER_H_ */
