/*
 * Copyright (C) 2007 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef COVERARTPROVIDER_H_INCLUDED
#define COVERARTPROVIDER_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qwidget.h>
#include <qimage.h>

class QImage;

class CoverArtProvider : public QObject
{
	Q_OBJECT
public:
	static CoverArtProvider& singleton();
#	define gCoverArtProvider CoverArtProvider::singleton()

	CoverArtProvider();
	virtual ~CoverArtProvider();

	static QString simplifyString(const QString &input);

	void setCoverArtDirectory(const QString &directory);

	QStringList findCoverArtImageFilenames(const QString &artist, const QString &album, const QString &filename);
	bool loadCoverDirectly(QImage &dstImage, const QString &artist, const QString &album, const QString &filename);

public slots:
	void rescan();

private:
	QString sourceDirectory_;
	QStringList coverArtImageFilenames_;
	QStringList simplifiedCoverArtImageFilenames_;
	QStringList validExtensionsList_;

#ifdef QT4
	inline bool validExtension(const QString &extension) { return validExtensionsList_.contains(extension.toLower()); }
#else
	inline bool validExtension(const QString &extension) { return validExtensionsList_.contains(extension.lower()); }
#endif

	void fillFileList(QStringList &filelist, const QString &path, const bool subdir);
};

#endif /*COVERARTPROVIDER_H_INCLUDED*/
