#include <stdlib.h>

#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>

#ifdef QT4
#include <QTextCodec>
#endif

#ifdef QTOPIA
#include <qpe/qcopenvelope_qws.h>
#endif

#include "externalservices.h"
#include "configuration.h"
#include "playlist.h"
#include "media.h"
#include "mediadatabase.h"

#include "compathack.h"

ExternalServices & ExternalServices::singleton()
{
	static ExternalServices instance;
	return instance;
}

ExternalServices::ExternalServices()
	:	playbackController_(NULL),
		currentMedia_(NULL)

{

}

ExternalServices::~ExternalServices()
{

}

QString ExternalServices::getTemporaryPlaybackStatusFileName()
{
	QString tempDir(::getenv("TMP"));
	if (tempDir.isEmpty())
	{
		tempDir = QString(::getenv("TMP"));
		if (tempDir.isEmpty())
		{
			tempDir = "/tmp";
		}
	}

	QString username(::getenv("USER"));
	if (!username.isEmpty())
		username = "_" + username;

	return tempDir + "/media" + username + ".sh";
}

void ExternalServices::playbackStarted()
{
	if (!playbackController_)
	{
		currentMedia_ = NULL;
		return;
	}

	currentMedia_ = playbackController_->activeItem()->media();

#ifdef QTOPIA
	if (currentMedia_->isVideo())
	{
		if (qConfig.qcopBroadcastingEnabled)
		{
			QCopEnvelope e("QPE/MediaPlayer", "playingVideo(QString, int)");
			e << currentMedia_->location().toString() << currentMedia_->length();
		}
	}
	else if (currentMedia_->isAudio())
	{
		if (qConfig.qcopBroadcastingEnabled)
		{
			if (currentMedia_->location().isLocalFile())
			{
				QCopEnvelope e("QPE/MediaPlayer", "playingAudio(QString, QString, QString, QString, int)");
				e << currentMedia_->location().toString() << currentMedia_->title() << currentMedia_->artist() << currentMedia_->album() << currentMedia_->length();
			}
			else
			{
				QCopEnvelope e("QPE/MediaPlayer", "playingStream(QString)");
				e << currentMedia_->location().toString();
			}
		}
	}
#endif

	writeCurrentMediaStatusToFile("playback_started");
}

void ExternalServices::playbackStopped()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "stopped()");
#endif

	if (qConfig.createTemporaryPlaybackStatusFile)
	{
		QFile file(getTemporaryPlaybackStatusFileName());

#ifdef QT4
		file.open(QIODevice::WriteOnly);
		QTextStream ts(&file);
		ts.setCodec(QTextCodec::codecForName("UTF-8"));
#else
		file.open(IO_WriteOnly);
		QTextStream ts(&file);
		ts.setEncoding(QTextStream::UnicodeUTF8);
#endif

		ts << "#!/bin/sh\n";
		ts << "# Auto-generated Quasar playback status file\n";
		ts << "# DO NOT EDIT!\n\n";
		ts << "status=stopped\n";

		file.close();
	}
}

void ExternalServices::playbackSeekedToAbsoluteSeconds(int secs)
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "seeked(int)") << secs;
#endif
}

void ExternalServices::playbackPaused()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "paused()");
#endif

	writeCurrentMediaStatusToFile("paused");
}

void ExternalServices::playbackUnpaused()
{
#ifdef QTOPIA
	if (qConfig.qcopBroadcastingEnabled)
		QCopEnvelope("QPE/MediaPlayer", "unpaused()");
#endif

	writeCurrentMediaStatusToFile("playing");
}

void ExternalServices::writeCurrentMediaStatusToFile(const QString &statusString)
{
	if (qConfig.createTemporaryPlaybackStatusFile && currentMedia_)
	{
		QFile file(getTemporaryPlaybackStatusFileName());
#ifdef QT4
		file.open(QIODevice::WriteOnly);
		QTextStream ts(&file);
		ts.setCodec(QTextCodec::codecForName("UTF-8"));
#else
		file.open(IO_WriteOnly);
		QTextStream ts(&file);
		ts.setEncoding(QTextStream::UnicodeUTF8);
#endif

		ts << "#!/bin/sh\n";
		ts << "# Auto-generated Quasar playback status file\n";
		ts << "# DO NOT EDIT!\n\n";
		ts << "status=" << statusString << "\n";
		ts << "mediatype=" << (currentMedia_->isVideo() ? "video" : currentMedia_->isAudio() ? "audio" : "stream") << "\n";
		ts << "artist=\"" << escapeString(currentMedia_->artist()) << "\"\n";
		ts << "album=\"" << escapeString(currentMedia_->album()) << "\"\n";
		ts << "title=\"" << escapeString(currentMedia_->title()) << "\"\n";
		//ts << "genre=" << escapeString(currentMedia_->genre()) << "\n";
		ts << "trackno=" << currentMedia_->trackNo() << "\n";
		ts << "length=" << currentMedia_->length() << "\n";
		ts << "location=\"" << currentMedia_->location().toString() << "\"\n";

		file.close();
	}
}

QString ExternalServices::escapeString(const QString &in)
{
	QString retval = in;
	retval.replace(QRegExp("\""), "\\\"");
	retval.replace(QRegExp("\\"), "\\\\");
	//retval.replace(QRegExp("$"), "\\$");
	return retval;
}
