#ifndef EXTERNALSERVICES_H
#define EXTERNALSERVICES_H

#include <qobject.h>

class Media;
class PlayListItem;
class PlaybackController;

class ExternalServices : public QObject
{
	Q_OBJECT

public:
	static ExternalServices& singleton();
#	define qExternalServices ExternalServices::singleton()

	ExternalServices();
	virtual ~ExternalServices();

	void setPlaybackController(PlaybackController *playbackController) { playbackController_ = playbackController; }

public slots:
	void playbackStarted();
	void playbackStopped();

	void playbackSeekedToAbsoluteSeconds(int);

	void playbackPaused();
	void playbackUnpaused();

public:
	QString getTemporaryPlaybackStatusFileName();

private:
	PlaybackController* playbackController_;
	Media *currentMedia_;

	void writeCurrentMediaStatusToFile(const QString &statusString);
	QString escapeString(const QString &in);
};

#endif	// EXTERNALSERVICES_H
