#ifndef HELPERS_H_
#define HELPERS_H_

#include <qstring.h>
#include <qwidget.h>

class QProcess;

QString formatFileSize(long long filesize);
QString formatBitrate(long long bitrate);
QString formatPlayTime(int lengthInSeconds, bool useShortestFormIfPossible = true);

void setStyleRecursively(QWidget *w, QStyle *s);
void saveWidgetPosition(QWidget *widget, const QString &configName, const QString &groupName);
void loadWidgetPosition(QWidget *widget, const QString &configName, const QString &groupName, int defX = -1, int defY = -1, int defWidth = 620, int defHeight = 400);

bool getHTTPProxySettings(QString &host, int &port);

bool isPathAbsolute(const QString &location);
QString resolveLocation(const QString &parentDir, const QString &location);
QString makeLocationRelative(const QString &parentDir, const QString &location);

void writeToProcess(QProcess *process, const QString &line);

#endif /* HELPERS_H_ */
