/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MEDIAIDENTIFIER_H_
#define MEDIAIDENTIFIER_H_

#include <qfileinfo.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qobject.h>
#include <qmap.h>
#include <qtimer.h>

#ifdef QT4
#include <QImage>
#include <QProcess>
#else
#include <qprocess.h>
#endif

#include <id3v2tag.h>
#include <xiphcomment.h>

#include "media.h"

bool containsUTF8(const QString &input);
QString reinterpretUTF8(const QString &input);

class MediaIdentifier : public QObject
{
	Q_OBJECT

public:
	static MediaIdentifier& singleton();
#	define gMediaIdentifier MediaIdentifier::singleton()

	MediaIdentifier();
	virtual ~MediaIdentifier();
	
	void identify(Media *media, const MediaLocation &location);	
	
	static bool loadCoverArtFromFile(const QString &filename, QImage &coverArtImage);	
	
private slots:
	void parseLines();
	void killIdentifyProcessTimerTimedOut();
	
private:
	Media *media_;
	bool fileScanningFinished_;
	QProcess *identifyProcess_;
	QTimer killIdentifyProcessTimer_;
	QString tempLine_;

	void cleanUpIdentifyProcess();
	void sendCommand(const QString &command);
		
	// Load tags
	bool loadTags(const MediaLocation &location, bool &tagsWereReadable, bool &audioPropertiesWereReadable);
	
	void identifyUsingMPlayer(Media *media, const MediaLocation &location);
	
	void addMediadata(const QString &tag, const QString &value);
	
	static void dumpXiphComment(TagLib::Ogg::XiphComment *xiphComment);
	static bool loadCoverArtFromID3v2(TagLib::ID3v2::Tag *id3v2Tag, QImage &coverArtImage);
	static bool loadCoverArtFromXiphComment(TagLib::Ogg::XiphComment *xiphComment, QImage &coverArtImage);	
};

#endif /*MEDIAIDENTIFIER_H_*/
