/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This file is based on eMotion by Michael Swieton <mike@swieton.net>.
 * The few remaining parts in this almost completely rewritten file are
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *                    Michael Swieton <mike@swieton.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPLAYER_H_INCLUDED
#define MPLAYER_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qtimer.h>
#include <qsocketnotifier.h>
#include <qtextstream.h>
#include <qprocess.h>

#include <sys/types.h>

#include "system_volume.h"
#include "signalhandler.h"

class Media;

class MPlayer: public QObject, SignalHandler
{
	Q_OBJECT

signals:
	void started();				//!< 再生開始(使われていない)
	void eof();
	void quit();				//!< 正常終了
	void killed();				//!< killされた
	void errorMessage(QString);
	void output(const QString&); //!< MPlayer出力(使われていない)
	void currentPlayTime(int);	//!< 現在の再生位置(秒単位)
	void paused();				// (使われていない)
	void resumed();				//!< resume from pause(使われていない)

public:
	MPlayer();
	~MPlayer();

	enum PlayResult {
		PlaybackInitiated,
		MediaNotFound,
		MediaNotSupported,
		InitializationFailed
	};

	bool checkFeatures();

#ifdef QT4
	bool isRunning() const { return process_ && process_->state() != QProcess::NotRunning; };
#else
	bool isRunning() const { return process_ && process_->isRunning(); };
#endif
	bool isPlaying() const { return isRunning() && playbackWasStarted_; }
	bool isPaused();

	void handleSignal(int);		// (使われていない)

	bool canRecycleMplayer(Media *);

public slots:
	PlayResult play(Media *);
	void pause();
	void stop() { stop(false); }
	void seekRelativeSeconds(int); //!< 相対シーク（n sec）
	void seekAbsolutePercentage(int); //!< 絶対シーク（0-100%）
	void seekAbsoluteSeconds(int); //!< 絶対シーク（n sec）
	void osdShowProgressBar(int); //!< プログレスバーを表示 (n sec)
	void toggleOSD();			//!< OSD表示のトグル
	void enableTemporaryOSD();	//!< OSDを一時的に表示する
	void disableTemporaryOSD();	//!< OSDを一時的に表示する
	void setBrightness(int);	//!< 明度の変更

private slots:
	void cleanUp();
	void processReadyReadStdout();
	void processExited();
	void parseLines();
	void pollMPlayer();			//!< 定期状態確認
	void checkFeaturesProcessParseLines();
	void systemVolumeChanged(int);

	void killWaitingProcesses();
	void updatedValues();

private:
	QStringList getArgListForMedia(Media *);
	bool canRecycleMplayer(Media *, QStringList &);
	void scheduleDestructionOfProcess(QProcess *);

	void sendCommand(const QString&); //!< slaveコマンド送信
	void sendMedia(Media *);
	void updatePosition();
	void sendCurrentVolume();
	bool useSoftVolume() { return qSystemVolume.useInternalVolume(); }

	void checkFeaturesRunProcess(const QString &program, const QStringList &args);
	void stop(bool emitQuitSignal);
	void quitMplayer(bool emitQuitSignal);

	/* MPlayer制御 */
	enum QuitState {
		QuitNull,
		QuitUser,
		QuitEOF
	};
	QuitState quitState_;		//!< 終了方法
	bool isPaused_;				//!< ポーズ状態
	bool playbackWasStarted_;
	bool errorDetected_;
	bool isSendingPTS_;			// is mplayer sending PTS=<currentplaytime> ?
	bool parsing_;
	int watchdogCheck_;

	QProcess *process_;
	QString lastMplayerBinLocation_;
	QStringList currentProcessArgs_;
	QString buffer_;
	QTimer timer_;	// 監視タイマ

	QString messages_;
	QString params_;

	QTimer killTimer_;
#ifdef QT4
	QList<QProcess *> processKillWaitList_;
#else
	QList<QProcess> processKillWaitList_;
#endif

	int newPlaytime_;

	bool isOSDVisible_;			//!< OSDの現在の表示状態
	bool isTemporaryOSDEnabled_; //!< 一時的にOSDを表示するモードになっているか
	bool savedOSDVisiblity_;	//!< 一時的にOSDを表示する前のOSD表示状態
	QTextStream logStream_;		//!< MPlayerの出力を保存するストリーム
};

#endif // MPLAYER_H_INCLUDED
