/*
 * PlaybackController.h
 *
 *  Created on: 09.07.2010
 *      Author: darkstar
 */

#ifndef PLAYBACKCONTROLLER_H_
#define PLAYBACKCONTROLLER_H_

#include <qobject.h>

#include "media.h"
#include "playlist.h"
#include "playlistaspectlistviewrenderer.h"

class MPlayer;
class QTimer;

class PlaybackController : public QObject
{
	Q_OBJECT
public:
	enum PlayOrder {
		PlayOrderNormal = 0,
		PlayOrderRepeatAll = 1,
		PlayOrderRepeatOne = 2,
		PlayOrderRandom = 3,
		PlayOrderRepeatRandom = 4,
		PlayOrderMax = 5
	};

	PlaybackController();
	virtual ~PlaybackController();

	void attachTo(PlayListAspectListViewRenderer *source);
	void detach();
	PlayListAspectListViewRenderer *aspectSource() { return aspectSource_; }

	// index based methods:
	int activeItemIndex();
	void setActiveItemIndex(int itemIndex);

	int nextActiveItemIndex(bool modifyRandomPlayOrderTableIndex = false);
	int previousActiveItemIndex(bool modifyRandomPlayOrderTableIndex = false);
	int relativeActiveItemIndex(int offset, bool modifyRandomPlayOrderTableIndex = false);

	// item based methods:
	PlayListItem *activeItem();
	void setActiveItem(PlayListItem *item);

	PlayListItem *nextItem(bool modifyRandomPlayOrderTableIndex = false);
	PlayListItem *previousItem(bool modifyRandomPlayOrderTableIndex = false);

	bool isPlaying();

public slots:
	void setPlayOrder(PlaybackController::PlayOrder newOrder);
	void togglePlayOrder();
	void toggleRandomPlayOrder();

	void stopCurrentPlaybackAndPlayCurrentItem();

	void startOrPauseCurrentPlaybackOrStartNewPlayback();
	void stopCurrentPlayback();
	void playNextItem();
	void playPreviousItem();

	void setAbsoluteSeconds(int secs);
	void setRelativeSeconds(int secs);

signals:
	void playOrderChanged(PlaybackController::PlayOrder newOrder);
	void activeItemChanged(int newActiveItemIndex, int oldActiveItemIndex);

	void startingPlayback();
	void playbackStarted();

	void stoppingPlayback(bool temporarily);
	void playbackStopped(bool temporarily);

	void playbackUnpaused();
	void playbackPaused();

	void currentPlayTime(int secs);
	void mediaPrefetched(PlayListItem *item);

	void playbackSeekedToAbsoluteSeconds(int secs);

	void problemWithMedia(PlayListItem *);
	void playerInitializationFailed(PlayListItem *);

private slots:
	void updateView();
	void osdTimerTimedUpdate();
	void mplayerErrorMessage(QString);
	void mplayerCurrentPlayTime(int seconds);

private:
	PlayListAspectListViewRenderer *aspectSource_;

	PlayOrder playOrder_;
	int *randomPlayOrderLUT_;

	int count_;
	int randomPlayOrderLUTIndex_;
	int activeItemIndex_;
	PlayListItem activeItem_;

	QTimer *osdTimer_;
	MPlayer *mplayer_;
	int keyEventCount_;
	bool nextMediaPrefetched_;
	int currentMediaLength_;

	void updateRandomPlayOrderLUT();
	void generateRandomPlayOrderLUT();

	void startOrPauseCurrentPlaybackOrStartNewPlayback(bool forcePlayNewFile);

	void internalStartPlayback();
	void internalStopPlayback(bool temporarily = false, bool stopBackend = true);
};

#endif /* PLAYBACKCONTROLLER_H_ */
