/*
 * playlistaspect.h
 *
 *  Created on: 15.04.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTASPECT_H_
#define PLAYLISTASPECT_H_

#include <qobject.h>

#include "playlist.h"

class PlayListAspectExtension;

#ifdef QT4
typedef QList<Media *> MediaList;
typedef QList<PlayListAspectExtension *> PlayListAspectExtensionList;
#else
typedef QList<Media> MediaList;
typedef QList<PlayListAspectExtension> PlayListAspectExtensionList;
#endif

class PlayListAspect;

class PlayListAspectExtension
{
public:
	PlayListAspectExtension() : playListAspect_(NULL) {};
	virtual ~PlayListAspectExtension() { }

	PlayListAspect *playListAspect() { return playListAspect_; }

	void update();

	virtual void reset();
	virtual const QString outputViewSource() = 0;

	virtual bool isActive();
	virtual bool isFiltering();

	bool isGraphFiltered();

	virtual const QString identifier() { return outputViewSource(); }
	virtual void saveExtensionState(QStringList &dst);
	virtual void loadExtensionState(QStringList &src);

protected:
	friend class PlayListAspect;

	void setPlayListAspect(PlayListAspect *playListAspect);

	virtual void attachedToAspect() {};
	virtual void removedFromAspect() {};

	void setExtensionList(PlayListAspectExtensionList *extensionList) { extensionList_ = extensionList; }
	PlayListAspectExtensionList *extenstionList() { return extensionList_; }

	QString inputViewSource();

	virtual void execute() = 0;

	bool exclusiveModeActive();
	void continueWithNextAspectExtension();

	PlayListAspectExtension *previousAspectExtension();
	PlayListAspectExtension *nextAspectExtension();

	virtual void extensionGraphExecutionStarted(bool &stopIt);
	virtual void extensionGraphExecutionFinished();

private:
	PlayListAspect *playListAspect_;
	PlayListAspectExtensionList *extensionList_;
};

class PlayListAspect : public QObject
{
	Q_OBJECT
public:
	PlayListAspect(PlayList *playList, const QString aspectName);
	virtual ~PlayListAspect();

	PlayList *playList() { return playList_; }
	const QString &name() { return aspectName_; }
	const QString &prefix() { return prefix_; }

	void registerExtension(PlayListAspectExtension *extension);
	void unregisterExtension(PlayListAspectExtension *extension);

	void loadFromDatabase();
	void saveToDatabase();

public slots:
	void update();

protected:
	friend class PlayListAspectExtension;

	void beginUpdate();
	void endUpdate();

	void runPreCondition(bool &stopExecution);
	void runPostCondition();

private:
	PlayList *playList_;
	QString aspectName_;
	QString prefix_;

	int updateCount_;
	bool preConditionFired_;

	PlayListAspectExtensionList extensions_;
	PlayListAspectExtension *filterExtensionStart_;
};

#endif /* PLAYLISTASPECT_H_ */
