/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLISTMANAGER_H_INCLUDED
#define PLAYLISTMANAGER_H_INCLUDED

#include <qobject.h>

#ifdef QT4
#include <QList>

#include <classcompathack.h>

#else
#include <qvaluelist.h>
#include <qlistbox.h>
class QWidgetStack;
#endif

#include "playlistview.h"
#include "playlist.h"
#include "playlistaspect.h"

class QWidget;
class QLabel;
class QProgressDialog;
class Configuration;
class Media;

class PlaybackController;

class PlayListAspectSearchFilter;
class PlayListAspectOverviewFilter;
class PlayListAspectStatisticsGatherer;
class PlayListAspectListViewRenderer;
class PlayListAspectAlbumGroupBuilder;

class PlayListSearchFilterLineEdit;
class PlayListOverview;
class CoverArtFlow;

struct PlayListAspectCompound
{
	PlayListAspect *aspect;
	PlayListAspectSearchFilter *searchFilter;
	PlayListAspectOverviewFilter *overviewFilter;
	PlayListAspectStatisticsGatherer *statistics;
	PlayListAspectListViewRenderer *listViewRenderer;
	PlayListAspectAlbumGroupBuilder *groupBuilder;
};

class PlayListManager : public QObject
{
	Q_OBJECT

public:
	PlayListManager(PlayListView *targetPlayList, PlaybackController *playbackController, QWidgetStack *container, Configuration &config, QWidget *owner);
	virtual ~PlayListManager();

	enum Mode {
		ModeDynPlaylistEditor = 0,
		ModeOpenedPlaylist = 1,
		ModeOnTheGoPlaylist = 2,
		ModeLastActivePlaylist = 3,
		ModeMax = 4
	};

	Mode activeMode() { return activeMode_; }
	bool setActiveMode(Mode mode);

	PlayListView::InputMode inputMode();
	void setInputMode(PlayListView::InputMode inputMode);

	bool isDynamicPlaylist() const { return currentPlayList_->isDynamic() && !(activeMode_ == ModeOnTheGoPlaylist); }
	bool isDynamicPlaylistEditorActive() const { return lboxDynPlayList_; }

	bool isAnythingSelected() const
	{
		return (!isDynamicPlaylistEditorActive() && playListView_->selectedItemsCount() > 0) ||
			(isDynamicPlaylistEditorActive() && lboxDynPlayList_->currentItem() > -1);
	}

	const QExtStringList &dynamicPlayList() { return currentPlayList_->dynPlayList(); }

	bool isOnTheGoPlayListActive() const { return currentPlayList_ == otgPlayList_; }

	int mediaClipboardCount() const { return mediaIDClipboard_.count(); }

	QString getDisplayPlayListFilename();

	bool readPlayList(const QString &filename, bool assumeInDB = false);
	bool openASX(const QString&);

	PlayList &playList() { return *playList_; }
	PlayList &otgPlayList() { return *otgPlayList_; }
	PlayList &currentPlayList() { return *currentPlayList_; }

	void setSearchFilterLineEdit(PlayListSearchFilterLineEdit *lineEdit) { searchFilterLineEdit_ = lineEdit; }
	void setPlayListOverview(PlayListOverview *overview) { playListOverview_ = overview; }
	void setCoverArtFlow(CoverArtFlow *coverArtFlow) { coverArtFlow_ = coverArtFlow; }

	MediaDatabase *mediaDatabase() { return mediaDatabase_; }

	void loadStates();
	void saveStates();

public slots:
	// Playlist edit
	void execDialogAddDirToPlayList();
	void execDialogAddDirWithSubDirsToPlayList();
	void execDialogAddFileToPlayList();
	void execDialogAddURLToPlayList() { openURL(NULL); }
	void removeFileFromPlayList();

	void refreshDynamicPlayList();

	void newPlayList();
	void newDynamicPlayList();
	void clearPlayList();
	void execDialogOpenPlayList();
	void savePlayList();
	void execDialogSavePlayListAs();

	void cutSelectionFromPlayList();
	void copySelectionFromPlayList();
	void pasteIntoPlayList();
	void selectAll();
	void deselectAll();
	void copyToOnTheGoPlayList();

signals:
	void playlistFileNameChanged();
	void playlistCleared();
	void playlistLoaded();
	void clipboardChanged();
	void selectionChanged();
	void switchingModeTo(PlayListManager::Mode mode);
	void switchedModeTo(PlayListManager::Mode mode);
	void showInfoText(const QString &text);
	void showMessage(const QString &message, int milliseconds = 3000);

private slots:
	void playListStartingActivity(const QString &activityName);
	void playListUpdateActivityProgress(const QString &text, int stepNo, int stepsTotal, bool &cancel);
	void playListFinishedActivity(const QString &activityName, bool canceled);

private:
	QWidget *owner_;
	PlayListSearchFilterLineEdit *searchFilterLineEdit_;
	PlayListView *playListView_;
	PlaybackController *playbackController_;
	PlayListOverview *playListOverview_;
	CoverArtFlow *coverArtFlow_;
	QWidgetStack *playListContainer_;
	Configuration &config_;

	QListBox *lboxDynPlayList_;
	QWidget *previouslyVisibleWidget_;

	MediaIDList mediaIDClipboard_;

	Mode activeMode_;

	MediaDatabase *mediaDatabase_;

	PlayList *playList_;
	PlayListAspectCompound playListAspectComp_;

	PlayList *otgPlayList_;
	PlayListAspectCompound otgPlayListAspectComp_;

	PlayList *currentPlayList_;
	PlayListAspectCompound *currentAspectComp_;

	QProgressDialog *progress_;
	QTime progressUpdateTime_;

	void initializeAspectCompound(PlayListAspectCompound *comp, PlayList *playList);
	void deinitializeAspectCompound(PlayListAspectCompound *comp);

	void openURL(const QString &uri);
	void addDialog(const bool, const bool subdir = false);
	void addFile(const QString&);
	void addDir(const QString&, const bool subdir = false);

	void checkInputMode();

	void writePlayList(const QString &filename);
	void readPlayList(const QString &filename, const QExtStringList &filelist, const QString &dialogTitle = NULL, bool assumeInDB = false);
};

#endif // PLAYLISTMANAGER_H_INCLUDED
