/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * This file based on eMotion by Michael Swieton <mike@swieton.net>
 *
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <cassert>

#include <stdio.h>

#include <signal.h>

#include "signalhandler.h"

#define NUMHANDLERS	32

/* XXX: size? */
static SignalHandler *_handlers[NUMHANDLERS];
static void signal_handler(int sig);

void register_handler(int sig, SignalHandler *h)
{
	if (_handlers[sig] && _handlers[sig] != h)
	{
		fprintf(stderr, "Signal congestion\n");
		return;
	}

	_handlers[sig] = h;
	signal (sig, signal_handler);
}

void unregister_handler(SignalHandler *h)
{
	for (int i = 0; i < NUMHANDLERS; i++)
	{
		if (_handlers[i] == h)
		{
			_handlers[i] = NULL;
			signal (i, SIG_DFL);
		}
	}
}

static void signal_handler (int sig)
{
	assert (_handlers[sig] != NULL);

	_handlers[sig]->handleSignal (sig);
}
