/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CUSTOMPERSPECTIVEIMAGEFLOW_H_
#define CUSTOMPERSPECTIVEIMAGEFLOW_H_

#include <qwidget.h>
#include <qimage.h>

#include "paintbox.h"
#include "transitiontimer.h"
#include "customflow.h"

class CustomPerspectiveImageFlow : public CustomFlow
{
	Q_OBJECT
public:
	enum AntialiasMode {
		NoAntialiasing = 0,
		AntialiasStaticSceneOnly = 1,
		AntialiasAlways = 2
	};
	
	CustomPerspectiveImageFlow(LayeredPaintBox *parent);

	void setVerticalOffset(int offset);
	int verticalOffset() const { return offset_; }

	void setConstantVerticalOffset(int offset);
	int constantVerticalOffset() const { return constantOffset_; }
	
	void setAntialiasMode(AntialiasMode mode);
	AntialiasMode antialiasMode() const { return antialiasMode_; }
	
protected:
	virtual QImage getImage(int index);
	virtual void paintToBuffer(QImage &buffer, const QRect &clipRect);
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);
	
	virtual void resized();
	virtual void mousePressEvent(QMouseEvent *event);
	virtual void mouseMoveEvent(QMouseEvent *event);
	virtual void mouseReleaseEvent(QMouseEvent *event);
	
	float hitTestIndex(int xPos, float transitionValue, const FloatArray &offsetValues, const FloatArray &distanceValues, bool omitDistanceSpace = false);
	
protected slots:	
	virtual void transitionStep(float start, float stop, float value, float step);
	virtual void transitionFinished();
	virtual void transitionStopped();
	
private:
	int offset_;
	int constantOffset_;
	bool antialias_;
	AntialiasMode antialiasMode_;
	
	FloatArray offsetValues_;
	FloatArray distanceValues_;
	bool mouseDown_;
	bool mouseMoved_;
	QPoint mouseDownPosition_;
	float mouseDownStartIndexValue_;
	float mouseDownIndexValue_;
	
	int lastPos_;
	int lastDiff_;
	int startPos_;
	bool isScrolling_;
	QTime startTime_;
	QTime lastUpdateTime_;
	int pixelPerSec_;
	int pixelsLeft_;
};

#endif /*CUSTOMPERSPECTIVEIMAGEFLOW_H_*/
