/*
 * Copyright (C) 2007-2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef REFLECTIONIMAGEFLOW_H_
#define REFLECTIONIMAGEFLOW_H_

#include "customscaledcachedimageprovider.h"
#include "customflow.h"
#include "customperspectiveimageflow.h"

QImage prepareImage(QImage image, int maxWidth, int maxHeight, int reflectionHeight);

class ReflectionImageProvider : public CustomScaledCachedImageProvider
{
	Q_OBJECT
public:
	ReflectionImageProvider(QObject *owner);
	
	void setRefSize(QSize size);
	QSize refSize() const { return refSize_; }
	
	void setReflectionHeight(int height);
	int reflectionHeight() const { return reflectionHeight_; }
	
	void setPreloadImageFilename(const QString &filename);
	QString preloadImageFilename() { return preloadImageFilename_; }
	
protected:
	virtual QImage* threadedCreateImage(CachedImage *cachedImage);
	virtual QImage* preloadImage(const QString &name, void *data);
	
private:
	void invalidatePreloadImage();
	void updatePreloadImage();
	
	QString preloadImageFilename_;
	QImage preloadImage_;
	QSize refSize_;
	int reflectionHeight_;
};


class ReflectionImageFlow : public CustomPerspectiveImageFlow
{
	Q_OBJECT
public:
	ReflectionImageFlow(ReflectionImageProvider *imageProvider, LayeredPaintBox *parent);
	void setFileNames(QStringList imageFileNames);
	virtual void setSlideSize(QSize size);

	void setReflectionHeight(int height) { imageProvider_->setReflectionHeight(height); }
	int reflectionHeight() const { return imageProvider_->reflectionHeight(); }
	
protected:
	virtual QImage getImage(int index);
	virtual void updateElementCountAndMidIndex();
	ReflectionImageProvider *imageProvider() { return imageProvider_; }
	virtual void resized();
	
protected slots:
	virtual void imageWasCached(CachedImage *cachedImage);
	virtual void imageSaved(CachedImage *cachedImage);
	virtual void imageIsNull(CachedImage *cachedImage);
	virtual void scaleWasChangedAndCacheWasFlushed();
	
private:
	QStringList imageFileNames_;
	QTimer invalidateTimer_;
	ReflectionImageProvider *imageProvider_;
	
	void triggerInvalidateTimer();

private slots:	
	void invalidateView();
};

#endif /*REFLECTIONIMAGEFLOW_H_*/
