/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef QUASAR_H_INCLUDED
#define QUASAR_H_INCLUDED

#include <qmainwindow.h>
#include <qstring.h>
#include <qaction.h>

#ifdef QT4
#include <QKeyEvent>
#include <QDragEnterEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QResizeEvent>
#include <QEvent>
#include <QCloseEvent>

#include <classcompathack.h>

#else
class QVBoxLayout;
class QWidgetStack;
class QVBox;
#endif

#ifdef QTOPIA
#include <qpe/qpestyle.h>
#endif
#ifdef WINDOWS
#include <qwindowsstyle.h>
#endif

#include "playlistmanager.h"
#include "playbackcontroller.h"
#include "skinmanager.h"

class MPlayer;
class Configuration;
class MediaDatabase;
class PlayListSearchFilterLineEdit;
class PlayListItem;
class PlayListView;
class PlayListOverview;
class CoverArtImageProvider;
class LayeredPaintBox;
class CoverArtFlow;
class SkinFlowScrollBar;
class OperationPanel;
class ToolPanel;
class PlayListToolPanel;
class PlayInfo;
class VideoPlaybackWindow;
class SkinManager;
class QMenuBar;
class QToolBar;
class QCloseEvent;
class QResizeEvent;
class QKeyEvent;
class QLineEdit;
class QSplitter;

#ifdef QT4
typedef QAction * QuasarMenuID;
#else
typedef int QuasarMenuID;
typedef QPopupMenu QMenu;
#endif

class Quasar: public QMainWindow
{
	Q_OBJECT
public:
	Quasar();
	~Quasar();

	enum View {
		ViewDynPlaylistEditor = 0,
		ViewOpenedPlaylist = 1,
		ViewOnTheGoPlaylist = 2,
		ViewLastActivePlaylist = 3,
		ViewPlayInfo = 4,
		ViewMax = 5
	};

	View activeView();
	bool setActiveView(View view);

public slots:
	void setOverviewVisibility(bool visible);
	void setCoverArtFlowVisibility(bool visible);
	void setInputMode(PlayListView::InputMode inputMode);
	void setFullScreen(int);

public slots:
	void init();

	void coverArtFlowAreaRearrangeLayers();

	// Configuration dialog
	void configuration();

	void toggleFullScreen();
	void toggleInfoWidget();
	void toggleOverviewVisibility();
	void toggleCoverArtFlowVisibility();
	void toggleSelectMode() { setInputMode(PlayListView::Select); }
	void toggleMultiSelectMode() { setInputMode(PlayListView::MultiSelect); }
	void toggleMoveItemMode() { setInputMode(PlayListView::Move); }
	void about();
	void rescanForCoverArt();
	void showMediaInfo();

	void setDocument(const QString&);

	void handleExternalDocuments(const QStringList &filenames);

	void resetFilterAndSorting();

	void filterEditBoxReturnPressed();
	void filterEditBoxTextChanged(const QString&);

	void resetFilter();
	void resetFilterAndFocusFilterEditBox();

	void updateButtonAndMenuState();
	void scheduleUpdateButtonAndMenuState();

	void fileMenuAboutToShow();
	void editMenuAboutToShow();
	void viewMenuAboutToShow();
	void toolsMenuAboutToShow();

	void switchPlaylistEditorView();
	void switchToLastActivePlayList();
	void switchToCurrentPlayList();
	void switchToOnTheGoPlayList();
	void switchToInfoWidget();

	void playlistManagerSwitchingModeTo(PlayListManager::Mode mode);
	void playlistManagerSwitchedModeTo(PlayListManager::Mode mode);
	void playlistToolPanelModeChanged(PlayListManager::Mode mode);
	void playlistManagerPlayListFileNameChanged();
	void playlistManagerPlayListCleared();

	void playlistOverviewFocusOutLeft();
	void playlistOverviewFocusOutRight();
	void setFocusPlayListOverview();

	void incDisplaySize();
	void decDisplaySize();

	void loadPrimarySkin();
	void loadSecondarySkin();

protected:
	void closeEvent(QCloseEvent*);
	void resizeEvent(QResizeEvent *);

#ifndef QTOPIA
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);
#endif

	bool eventFilter(QObject *, QEvent *);

private slots:
	void controlsMenuPlayOrderChanged(int playOrderID);
	void playbackControllerChangedPlayOrder(PlaybackController::PlayOrder);

	void playbackControllerStoppingPlayback(bool temporarily);
	void playbackControllerPlaybackStopped(bool temporarily);
	void playbackControllerPlaybackStarted();
	void playbackControllerCurrentPlayTime(int seconds);
	void playbackControllerPlaybackPaused();
	void playbackControllerPlaybackUnpaused();

	void playbackControllerMediaPrefetched(PlayListItem *item);
	void playbackControllerProblemWithMedia(PlayListItem *item);
	void playbackControllerPlayerInitializationFailed(PlayListItem *item);

private:
	int fullScreenMenuItemID_;
	enum WIDGETID {
		InfoWidget, PlayListWidget
	};

	bool filterActive();
	void setupMenu();

	QAction *createAction(const QString& actionName, const QObject *receiver, const char *member);

	QMenu *createMenu(QMenuBar *menuBar, const char *menuText, QMenu *parent = NULL);

	QuasarMenuID createMenuItem(QMenu *menu, const char *menuText, QAction *action);
	QuasarMenuID createMenuItem(QMenu *menu, const char *menuText, const QObject * receiver, const char * member);
	QuasarMenuID createMenuSeparator(QMenu *menu);
	inline void menuItemSetText(QMenu *menu, QuasarMenuID id, const char *text);
	inline void menuItemSetEnabled(QMenu *menu, QuasarMenuID id, bool value);
	inline void menuItemSetChecked(QMenu *menu, QuasarMenuID id, bool value);

	void setupActions();

	void setPlayListFont(SkinManager::InfoMode mode);
	void changeOrientation(bool landscape, bool setSkinStyle = true, bool saveCurrentColumnWidths = true);
	void checkOrientation();

	void configuration(bool showMPlayerConfig);
	void readFromConfig();

	void updateSplitterSectionHeights();

	void loadSkin(const QString &name, bool force = false);

	bool receivedExternalDocuments_;
	bool isFullScreen_;
	bool wasMaximized_;

	VideoPlaybackWindow *videoPlaybackWindow_;
	QTimer *updateButtonAndMenuTimer_;

public:
	SkinManager *skinManager_;

	// Widgets
	QWidget *centralWidget_;

	PlayListManager *playListManager_;
	PlaybackController *playbackController_;
	PlayListView *playListView_;
	PlayListOverview *playListOverview_;
	CoverArtImageProvider *coverArtProviderCoverArtFlow_;
	CoverArtImageProvider *coverArtProviderPlayInfo_;

	LayeredPaintBox *coverArtFlowArea_;
	CoverArtFlow *coverArtFlow_;
	SkinFlowScrollBar *flowScrollBar_;

	PlayInfo *playInfo_;
	OperationPanel *operationPanel_;
	ToolPanel *toolPanel_;
	PlayListToolPanel *playListToolPanel_;
	PlayListSearchFilterLineEdit *filterEditBox_;

	// Layout
	int currentWidth_;
	QVBoxLayout *screen_;	// Screen layout
	QWidgetStack *widgetStack_, *playlistStack_;
	QVBox *playListContainer_;
	QSplitter *horizontalSplitterContainer_;
	QSplitter *verticalSplitterContainer_;

	// Menu
	QMenuBar *menuBar_;

	QMenu *fileMenu_, *playbackOrderMenu_, *controlsMenu_, *sortByMenu_, *editMenu_, *viewMenu_, *toolsMenu_;

	QToolBar *toolBar_;
	QToolBar *subBar_;

	QuasarMenuID idFileMenuNewPlaylist_;
	QuasarMenuID idFileMenuNewDynPlaylist_;
	QuasarMenuID idFileMenuOpenPlaylist_;
	QuasarMenuID idFileMenuSavePlaylist_;
	QuasarMenuID idFileMenuSaveAsPlaylist_;

	QuasarMenuID idEditMenuCutItem_;
	QuasarMenuID idEditMenuCopyItem_;
	QuasarMenuID idEditMenuPasteItem_;
	QuasarMenuID idEditMenuDeleteItem_;
	QuasarMenuID idEditMenuSelectModeItem_;
	QuasarMenuID idEditMenuMultiSelectModeItem_;
	QuasarMenuID idEditMenuMoveItemModeItem_;
	QuasarMenuID idEditMenuCopyToOTGItem_;
	QuasarMenuID idEditMenuShowMediaInfoItem_;

	QuasarMenuID idViewMenuFullscreenItem_;
	QuasarMenuID idViewMenuShowOverviewItem_;
	QuasarMenuID idViewMenuShowCoverArtFlowItem_;
	QuasarMenuID idViewMenuCurrentPlayListItem_;
	QuasarMenuID idViewMenuOnTheGoPlayListItem_;
	QuasarMenuID idViewMenuDynamicPlayListEditorItem_;
	QuasarMenuID idViewMenuPlayInfoItem_;
	QuasarMenuID idViewMenuIncDisplaySize_;
	QuasarMenuID idViewMenuDecDisplaySize_;
	QuasarMenuID idViewMenuQuickswitchSkin1_;
	QuasarMenuID idViewMenuQuickswitchSkin2_;

	QuasarMenuID idToolsMenuRescanDynamicPlaylist_;
	QuasarMenuID idToolsMenuRescanForCoverArt_;
	QuasarMenuID idToolsMenuConfiguration_;
	QuasarMenuID idToolsMenuAbout_;

	QAction *acPlayInfoToggle;
	QAction *acMoveBack;
	QAction *acMoveForward;
	QAction *acDelete;
};

#endif // QUASAR_H_INCLUDED
