#ifndef COVERARTFLOW_H_
#define COVERARTFLOW_H_

#include <qtimer.h>

#include "reflectionimageflow.h"
#include "coverartimageprovider.h"
#include "playlistview.h"
#include "skinscrollbar.h"
#include "media.h"
#include "playlistaspectalbumgroupbuilder.h"

class CoverArtFlow : public ReflectionImageFlow
{
	Q_OBJECT
public:
	CoverArtFlow(ReflectionImageProvider *imageProvider, LayeredPaintBox *parent);
	virtual ~CoverArtFlow();

	void attachTo(PlayListAspectAlbumGroupBuilder *source);
	void detach();
	PlayListAspectAlbumGroupBuilder *aspectSource() { return aspectSource_; }

	void setActive(bool value);
	void reset();

	void setPlayListView(PlayListView *target);
	PlayListView *playListView() { return playListView_; }

public slots:
	void updateView();

protected:
	virtual QImage getImage(int index);

	virtual void transitionFinished();
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);

	virtual void mouseDoubleClickEvent(QMouseEvent *e);

private slots:
	void playListCurrentChanged();
	void imageWasCached(CachedImage *image);
	void preloadImages();
	void focusCurrentAlbum();

private:
	MediaDatabase *mediaDatabase_;
	PlayListAspectAlbumGroupBuilder *aspectSource_;
	PlayListView *playListView_;
	bool active_;

	QTimer preloadImagesTimer_;
	QTimer focusAlbumTimer_;
};

#endif /*COVERARTFLOW_H_*/
