/*
 * playlistsearchfilterlineedit.cpp
 *
 *  Created on: 14.06.2010
 *      Author: darkstar
 */

#include <qtimer.h>

#include "playlistsearchfilterlineedit.h"
#include "mediadatabase.h"
#include "playlistaspect.h"
#include "playlistaspectsearchfilter.h"
#include "configuration.h"

PlayListSearchFilterLineEdit::PlayListSearchFilterLineEdit(QWidget *parent)
	: QLineEdit(parent),
	  mediaDatabase_(NULL),
	  aspectSource_(NULL),
	  newFilterText_("")
{
	filterEditTimer_ = new QTimer(this);
	connect(filterEditTimer_, SIGNAL(timeout()), this, SLOT(filterEditBoxTimedUpdate()));
	connect(this, SIGNAL(textChanged(const QString&)), this, SLOT(filterEditBoxTextChanged(const QString&)));
}

PlayListSearchFilterLineEdit::~PlayListSearchFilterLineEdit()
{

}

void PlayListSearchFilterLineEdit::filterEditBoxTextChanged(const QString &text)
{
	if (!aspectSource_) return;

	newFilterText_ = text;

	if (filterEditTimer_->isActive())
		filterEditTimer_->stop();

	filterEditTimer_->start(qConfig.playlistAutoTriggerFilterInterval, TRUE);
}

void PlayListSearchFilterLineEdit::filterEditBoxTimedUpdate()
{
	if (!aspectSource_) return;

	aspectSource_->setFilterText(newFilterText_);
}

void PlayListSearchFilterLineEdit::attachTo(PlayListAspectSearchFilter *source)
{
	detach();

	if (source)
	{
		blockSignals(true);
		setText(source->filterText());
		blockSignals(false);
		aspectSource_ = source;
		mediaDatabase_ = aspectSource_->playListAspect()->playList()->mediaDatabase();
	}
}

void PlayListSearchFilterLineEdit::detach()
{
	if (aspectSource_)
	{
		mediaDatabase_ = NULL;
		aspectSource_ = NULL;

		newFilterText_ = "";
		blockSignals(true);
		setText("");
		blockSignals(false);
	}
}
