/*
 * playlistsearchfilterlineedit.h
 *
 *  Created on: 14.06.2010
 *      Author: darkstar
 */

#ifndef PLAYLISTSEARCHFILTERLINEEDIT_H_
#define PLAYLISTSEARCHFILTERLINEEDIT_H_

#include <qlineedit.h>

class QTimer;
class PlayListAspectSearchFilter;
class MediaDatabase;

class PlayListSearchFilterLineEdit : public QLineEdit
{
	Q_OBJECT
public:
	PlayListSearchFilterLineEdit(QWidget *parent);
	virtual ~PlayListSearchFilterLineEdit();

	void attachTo(PlayListAspectSearchFilter *source);
	void detach();
	PlayListAspectSearchFilter *aspectSource() { return aspectSource_; }

private slots:
	void filterEditBoxTextChanged(const QString &text);
	void filterEditBoxTimedUpdate();

private:
	MediaDatabase *mediaDatabase_;
	PlayListAspectSearchFilter *aspectSource_;

	QTimer *filterEditTimer_;
	QString newFilterText_;
};

#endif /* PLAYLISTSEARCHFILTERLINEEDIT_H_ */
